// --------------------------------------------------------------------
// CUnMaterialSequence.hxx
// Whatis:  Unreal Import
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnMaterialSequence_hxx
#define CUnMaterialSequence_hxx
#include    "CUnProperty.hxx"

// --------------------------------------------------------------------
// Actions with material
// --------------------------------------------------------------------
typedef	enum {
	MSA_ShowMaterial	= 0,	// Show instantly
	MSA_FadeToMaterial	= 1		// Fade into this one
}	MSA_action_t;

// --------------------------------------------------------------------
// Structure containing the fetched items
// --------------------------------------------------------------------
typedef struct	material_sequence_s {
	dword_t			msa_object;	// Object reference
	float			msa_time;	// Time for this object
	MSA_action_t	msa_action;	// Action for it
}	material_sequence_t,
*	material_sequence_tp;
typedef list <struct material_sequence_s>		material_sequence_tl;
typedef material_sequence_tl::iterator			material_sequence_tli;
typedef material_sequence_tl::const_iterator	material_sequence_tlci;

// --------------------------------------------------------------------
// Declaration of the CUnMaterialSequence class
// --------------------------------------------------------------------
class   CUnMaterialSequence {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnMaterialSequence ( 	CUnFile_t &,
							const CUnNameTable_t &,
                    		const CUnExportTable_t &,
                    		const CUnImportTable_t & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnMaterialSequence();

    // ----------------------------------------------------------------
    public:     // Accessing instance data
    // ----------------------------------------------------------------
    const material_sequence_tl &	Sequence ( void ) const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void		SetMyItems	(	CUnProperty &,
							    CUnFile_t &,
								const CUnNameTable_t &,
	                    		const CUnExportTable_t &,
	                    		const CUnImportTable_t & );
    
    void        Cleanup		( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
	material_sequence_tl	itsSequence;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnMaterialSequence               CUnMaterialSequence_t;
typedef class CUnMaterialSequence *             CUnMaterialSequence_tp;
typedef list <class CUnMaterialSequence>        CUnMaterialSequence_tl;
typedef CUnMaterialSequence_tl::iterator        CUnMaterialSequence_tli;
typedef CUnMaterialSequence_tl::const_iterator  CUnMaterialSequence_tlci;

#endif  // #ifdef  CUnMaterialSequence_hxx
// --------------------------------------------------------------------
// EOF: CUnMaterialSequence.hxx
// --------------------------------------------------------------------
