// --------------------------------------------------------------------
// CUnNameTable.hxx
// Whatis:  Unreal Name
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CUnNameTable_hxx
#define CUnNameTable_hxx
#include    "CUnName.hxx"

// --------------------------------------------------------------------
// Declaration of the CUnNameTable class
// --------------------------------------------------------------------
class   CUnNameTable {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CUnNameTable ( CUnFile & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CUnNameTable();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    CUnNameTable              ( const CUnNameTable & );
    CUnNameTable & operator = ( const CUnNameTable & );

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    const char *            Name    ( dword_t )         const;
    const char *            LcName  ( dword_t )         const;
    const char *            Name    ( const char * )    const;
    const CUnObjectFlags_t  Flags   ( dword_t )         const;
    const CUnObjectFlags_t  Flags   ( const char * )    const;
    bool                    Exist   ( const char * )    const;
    dword_t                 Find    ( const char * )    const;
    dword_t                 Count   ( void )            const;

    // ----------------------------------------------------------------
    private:    // Private helpers
    // ----------------------------------------------------------------
    void    Cleanup( void );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    CUnName_tp      itsNameList;
    dword_t         itsNameCount;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CUnNameTable               CUnNameTable_t;
typedef class CUnNameTable *             CUnNameTable_tp;

#endif  // #ifdef  CUnNameTable_hxx
// --------------------------------------------------------------------
// EOF: CUnNameTable.hxx
// --------------------------------------------------------------------
