// --------------------------------------------------------------------
// CUnExportTable.cxx
// Whatis:  Unreal Export table
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CUnExportTable.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CUnExportTable::CUnExportTable ( CUnFile & aUf ) {
    CUnExportTable::Cleanup();
	try {
	    itsExportList = new CUnExport_t [ aUf.ExportCount() ];
	    if  ( ! itsExportList )   throw CError( "Out of memory" );
	
	    aUf.Seek( aUf.ExportOffset() );
	
	    while   ( itsExportCount < aUf.ExportCount() ) {
	        itsExportList[itsExportCount++] = CUnExport( aUf );
	    }
	}
	catch ( CError e ) {
	    if  ( itsExportList )   delete [] itsExportList;
    	CUnExportTable::Cleanup();
    	throw	CError( "CUnExportTable::CUnExportTable", e.Error() );
	}
	catch ( ... ) {
	    if  ( itsExportList )   delete [] itsExportList;
    	CUnExportTable::Cleanup();
    	throw;
	}
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnExportTable::~CUnExportTable () {
    if  ( itsExportList )   delete [] itsExportList;
    CUnExportTable::Cleanup();
}

// --------------------------------------------------------------------
// public:      Get one import
// --------------------------------------------------------------------
CUnExport_t CUnExportTable::Export  ( dword_t aIndex ) const {
    return  aIndex < itsExportCount ? itsExportList[aIndex] : CUnExport();
}

// --------------------------------------------------------------------
// private:     Cleenex
// --------------------------------------------------------------------
void    CUnExportTable::Cleanup( void ) {
    itsExportList   = NULL;
    itsExportCount  = 0;
}

// --------------------------------------------------------------------
dword_t     CUnExportTable::Count   ( void ) const { return itsExportCount; }

// --------------------------------------------------------------------
// EOF: CUnExportTable.cxx
// --------------------------------------------------------------------
