// --------------------------------------------------------------------
// CUnImport.cxx
// Whatis:	Unreal Import
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-NOV-2001		Created	this source
// --------------------------------------------------------------------
#include	"CUnImport.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:		Constructor	#1
// --------------------------------------------------------------------
CUnImport::CUnImport( CUnFile &	aUf	) {
	try {
		CUnImport::Cleanup();
		itsClassPackage	= aUf.ReadIndex();
		itsClassName	= aUf.ReadIndex();
		itsPackage		= aUf.ReadDword();
		itsObjectName	= aUf.ReadIndex();
	}
	catch	( CError e ) {
		throw CError( "CUnImport::CUnImport", e.Error() );
	}
}

// --------------------------------------------------------------------
// public:		Constructor	#2
// --------------------------------------------------------------------
CUnImport::CUnImport() {
	CUnImport::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CUnImport::~CUnImport()	{
	CUnImport::Cleanup();
}


// --------------------------------------------------------------------
// public:		Clean it up
// --------------------------------------------------------------------
void		CUnImport::Cleanup(	void ) {
	itsClassPackage	= 0;
	itsClassName	= 0;
	itsPackage		= 0;
	itsObjectName	= 0;
}

// --------------------------------------------------------------------
dword_t     CUnImport::ClassPackage    ( void ) const { return itsClassPackage; }
dword_t     CUnImport::ClassName       ( void ) const { return itsClassName; }
dword_t     CUnImport::Package         ( void ) const { return itsPackage; }
dword_t     CUnImport::ObjectName      ( void ) const { return itsObjectName; }

// --------------------------------------------------------------------
// EOF:	CUnImport.cxx
// --------------------------------------------------------------------
