// --------------------------------------------------------------------
// CUnObjectFlags.cxx
// Whatis:  Unreal object flags
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CUnObjectFlags.hxx"

// --------------------------------------------------------------------
// public:      Constructor #1
// --------------------------------------------------------------------
CUnObjectFlags::CUnObjectFlags ( CUnFile & aUf ) {
    itsFlags = 0;
    itsFlags = aUf.ReadDword();
}

// --------------------------------------------------------------------
// public:      Constructor #2
// --------------------------------------------------------------------
CUnObjectFlags::CUnObjectFlags () {
    itsFlags = 0;
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnObjectFlags::~CUnObjectFlags() {
    itsFlags = 0;
}

// --------------------------------------------------------------------
CUnObjectFlags & CUnObjectFlags::operator = ( dword_t aDw ) { itsFlags = aDw; return *this; }

// --------------------------------------------------------------------
dword_t     CUnObjectFlags::Flags           ( void ) const  { return itsFlags; }
bool        CUnObjectFlags::Transactional   ( void ) const  { return (itsFlags & RF_Transactional) != 0; }
bool        CUnObjectFlags::Unreachable     ( void ) const  { return (itsFlags & RF_Unreachable) != 0; }
bool        CUnObjectFlags::Public          ( void ) const  { return (itsFlags & RF_Public) != 0; }
bool        CUnObjectFlags::TagImp          ( void ) const  { return (itsFlags & RF_TagImp) != 0; }
bool        CUnObjectFlags::TagExp          ( void ) const  { return (itsFlags & RF_TagExp) != 0; }
bool        CUnObjectFlags::SourceModified  ( void ) const  { return (itsFlags & RF_SourceModified) != 0; }
bool        CUnObjectFlags::TagGarbage      ( void ) const  { return (itsFlags & RF_TagGarbage) != 0; }
bool        CUnObjectFlags::NeedLoad        ( void ) const  { return (itsFlags & RF_NeedLoad) != 0; }
bool        CUnObjectFlags::HighlightedName ( void ) const  { return (itsFlags & RF_HighlightedName) != 0; }
bool        CUnObjectFlags::EliminateObject ( void ) const  { return (itsFlags & RF_EliminateObject) != 0; }
bool        CUnObjectFlags::InSingularFunc  ( void ) const  { return (itsFlags & RF_InSingularFunc) != 0; }
bool        CUnObjectFlags::RemappedName    ( void ) const  { return (itsFlags & RF_RemappedName) != 0; }
bool        CUnObjectFlags::Suppress        ( void ) const  { return (itsFlags & RF_Suppress) != 0; }
bool        CUnObjectFlags::StateChanged    ( void ) const  { return (itsFlags & RF_StateChanged) != 0; }
bool        CUnObjectFlags::InEndState      ( void ) const  { return (itsFlags & RF_InEndState) != 0; }
bool        CUnObjectFlags::Transient       ( void ) const  { return (itsFlags & RF_Transient) != 0; }
bool        CUnObjectFlags::PreLoading      ( void ) const  { return (itsFlags & RF_Preloading) != 0; }
bool        CUnObjectFlags::LoadForClient   ( void ) const  { return (itsFlags & RF_LoadForClient) != 0; }
bool        CUnObjectFlags::LoadForServer   ( void ) const  { return (itsFlags & RF_LoadForServer) != 0; }
bool        CUnObjectFlags::LoadForEdit     ( void ) const  { return (itsFlags & RF_LoadForEdit) != 0; }
bool        CUnObjectFlags::Standalone      ( void ) const  { return (itsFlags & RF_Standalone) != 0; }
bool        CUnObjectFlags::NotForClient    ( void ) const  { return (itsFlags & RF_NotForClient) != 0; }
bool        CUnObjectFlags::NotForServer    ( void ) const  { return (itsFlags & RF_NotForServer) != 0; }
bool        CUnObjectFlags::NotForEdit      ( void ) const  { return (itsFlags & RF_NotForEdit) != 0; }
bool        CUnObjectFlags::Destroyed       ( void ) const  { return (itsFlags & RF_Destroyed) != 0; }
bool        CUnObjectFlags::NeedPostLoad    ( void ) const  { return (itsFlags & RF_NeedPostLoad) != 0; }
bool        CUnObjectFlags::HasStack        ( void ) const  { return (itsFlags & RF_HasStack) != 0; }
bool        CUnObjectFlags::Native          ( void ) const  { return (itsFlags & RF_Native) != 0; }
bool        CUnObjectFlags::Marked          ( void ) const  { return (itsFlags & RF_Marked) != 0; }
bool        CUnObjectFlags::ErrorShutdown   ( void ) const  { return (itsFlags & RF_ErrorShutdown) != 0; }
bool        CUnObjectFlags::DebugPostLoad   ( void ) const  { return (itsFlags & RF_DebugPostLoad) != 0; }
bool        CUnObjectFlags::DebugSerialize  ( void ) const  { return (itsFlags & RF_DebugSerialize) != 0; }
bool        CUnObjectFlags::DebugDestroy    ( void ) const  { return (itsFlags & RF_DebugDestroy) != 0; }
dword_t     CUnObjectFlags::ContextFlags    ( void ) const  { return itsFlags & RF_ContextFlags; }
dword_t     CUnObjectFlags::LoadContextFlags( void ) const  { return itsFlags & RF_LoadContextFlags; }
dword_t     CUnObjectFlags::LoadFlags       ( void ) const  { return itsFlags & RF_Load; }
bool        CUnObjectFlags::Keep            ( void ) const  { return (itsFlags & RF_Keep) == RF_Keep; }
dword_t     CUnObjectFlags::ScriptFlags     ( void ) const  { return itsFlags & RF_ScriptMask; }

// --------------------------------------------------------------------
// EOF: CUnObjectFlags.hxx
// --------------------------------------------------------------------
