// --------------------------------------------------------------------
// CError.cxx
// Whatis:  Error exception class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	<string>

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CError::CError  (   const char * aE1,
                    const char * aE2,
                    const char * aE3 ) {
    CError::Cleanup();
    CError::Setup( aE1, aE2, aE3 );
}

// --------------------------------------------------------------------
// public:      Copy constructor
// --------------------------------------------------------------------
CError::CError  (  const CError & aError ) {
    CError::Cleanup();
    CError::Setup( aError.Error(), NULL, NULL );
}

// --------------------------------------------------------------------
// public:      Assignment operator
// --------------------------------------------------------------------
CError & CError::operator = ( const CError & aError ) {
    if  ( itsError )    delete [] itsError;
    CError::Cleanup();
    CError::Setup( aError.Error(), NULL, NULL );
    return  *this;
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CError::~CError () {
    if  ( itsError )    delete [] itsError;
    CError::Cleanup();
}

// --------------------------------------------------------------------
// private:     Setup
// --------------------------------------------------------------------
void    CError::Setup   (   const char * aE1,
                            const char * aE2,
                            const char * aE3 ) {
    int     len = 0;
    if  ( aE1 ) len = len + ::strlen( aE1 ) + 4;
    if  ( aE2 ) len = len + ::strlen( aE2 ) + 4;
    if  ( aE3 ) len = len + ::strlen( aE3 ) + 4;
    itsError = new char [ len ];
    if  ( itsError ) {
        *itsError = 0;
        if  ( aE1 ) ::strcat( itsError, aE1 );
        if  ( aE2 ) {
            if  ( *itsError )   ::strcat( itsError, " : " );
            ::strcat( itsError, aE2 );
        }
        if  ( aE3 ) {
            if  ( *itsError )   ::strcat( itsError, " : " );
            ::strcat( itsError, aE3 );
        }
    }
}

// --------------------------------------------------------------------
// private:     Cleanup
// --------------------------------------------------------------------
void    CError::Cleanup ( void ) {
    itsError = NULL;
}

// --------------------------------------------------------------------
const char *    CError::Error ( void ) const { return (const char *)( itsError ? itsError : "Out of memory" ); }

// --------------------------------------------------------------------
// EOF: CError.cxx
// --------------------------------------------------------------------
