// --------------------------------------------------------------------
// CIOConvert.cxx
// Whatis:  Conversion between internal and external representations
//          of integers
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CIOConvert.hxx"

// --------------------------------------------------------------------
// Define the needed structures
// --------------------------------------------------------------------
#ifdef  NEEDS_WORD_CONVERSION
typedef union {
    char    byte[2];
    word_t  word;
    int2_t  int2;
}   io_word_t;
#endif

// --------------------------------------------------------------------
#ifdef  NEEDS_DWORD_CONVERSION
typedef union {
    char    byte[2];
    dword_t dword;
    int4_t  int4;
    float   fp;
}   io_dword_t;
#endif

// --------------------------------------------------------------------
// public:      Conversion routines
// --------------------------------------------------------------------
word_t      CIOConvert::Import ( word_t aWord )   const {
#ifdef  NEEDS_WORD_CONVERSION
    io_word_t   i, o;

    i.word = aWord;
    o.byte[ 0 ] = i.byte[ WORD_0_PLACE ];
    o.byte[ 1 ] = i.byte[ WORD_1_PLACE ];

    return  o.word;
#else
    return  aWord;
#endif
}

// --------------------------------------------------------------------
dword_t     CIOConvert::Import ( dword_t aDword ) const {
#ifdef  NEEDS_DWORD_CONVERSION
    io_dword_t  i, o;

    i.dword = aDword;
    o.byte[ 0 ] = i.byte[ DWORD_0_PLACE ];
    o.byte[ 1 ] = i.byte[ DWORD_1_PLACE ];
    o.byte[ 2 ] = i.byte[ DWORD_2_PLACE ];
    o.byte[ 3 ] = i.byte[ DWORD_3_PLACE ];

    return  o.dword;
#else
    return  aDword;
#endif
}

// --------------------------------------------------------------------
int2_t      CIOConvert::Import ( int2_t aInt2 )   const {
#ifdef  NEEDS_WORD_CONVERSION
    io_word_t   i, o;

    i.int2 = aInt2;
    o.byte[ 0 ] = i.byte[ WORD_0_PLACE ];
    o.byte[ 1 ] = i.byte[ WORD_1_PLACE ];

    return  o.int2;
#else
    return  aInt2;
#endif
}

// --------------------------------------------------------------------
int4_t      CIOConvert::Import ( int4_t aInt4 )   const {
#ifdef  NEEDS_DWORD_CONVERSION
    io_dword_t  i, o;

    i.int4 = aInt4;
    o.byte[ 0 ] = i.byte[ DWORD_0_PLACE ];
    o.byte[ 1 ] = i.byte[ DWORD_1_PLACE ];
    o.byte[ 2 ] = i.byte[ DWORD_2_PLACE ];
    o.byte[ 3 ] = i.byte[ DWORD_3_PLACE ];

    return  o.int4;
#else
    return  aInt4;
#endif
}

// --------------------------------------------------------------------
float       CIOConvert::Import ( float aFloat )   const {
#ifdef  NEEDS_DWORD_CONVERSION
    io_dword_t  i, o;

    i.fp = aFloat;
    o.byte[ 0 ] = i.byte[ DWORD_0_PLACE ];
    o.byte[ 1 ] = i.byte[ DWORD_1_PLACE ];
    o.byte[ 2 ] = i.byte[ DWORD_2_PLACE ];
    o.byte[ 3 ] = i.byte[ DWORD_3_PLACE ];

    return  o.fp;
#else
    return  aFloat;
#endif
}

// --------------------------------------------------------------------
word_t      CIOConvert::Export ( word_t aWord )   const {
#ifdef  NEEDS_WORD_CONVERSION
    io_word_t   i, o;

    i.word = aWord;
    o.byte[ WORD_0_PLACE ] = i.byte[ 0 ];
    o.byte[ WORD_1_PLACE ] = i.byte[ 1 ];

    return  o.word;
#else
    return  aWord;
#endif
}

// --------------------------------------------------------------------
dword_t     CIOConvert::Export ( dword_t aDword ) const {
#ifdef  NEEDS_DWORD_CONVERSION
    io_dword_t  i, o;

    i.dword = aDword;
    o.byte[ DWORD_0_PLACE ] = i.byte[ 0 ];
    o.byte[ DWORD_1_PLACE ] = i.byte[ 1 ];
    o.byte[ DWORD_2_PLACE ] = i.byte[ 2 ];
    o.byte[ DWORD_3_PLACE ] = i.byte[ 3 ];

    return  o.dword;
#else
    return  aDword;
#endif
}

// --------------------------------------------------------------------
int2_t      CIOConvert::Export ( int2_t aInt2 )   const {
#ifdef  NEEDS_WORD_CONVERSION
    io_word_t   i, o;

    i.int2 = aInt2;
    o.byte[ WORD_0_PLACE ] = i.byte[ 0 ];
    o.byte[ WORD_1_PLACE ] = i.byte[ 1 ];

    return  o.int2;
#else
    return  aInt2;
#endif
}

// --------------------------------------------------------------------
int4_t      CIOConvert::Export ( int4_t aInt4 )   const {
#ifdef  NEEDS_DWORD_CONVERSION
    io_dword_t  i, o;

    i.int4 = aInt4;
    o.byte[ DWORD_0_PLACE ] = i.byte[ 0 ];
    o.byte[ DWORD_1_PLACE ] = i.byte[ 1 ];
    o.byte[ DWORD_2_PLACE ] = i.byte[ 2 ];
    o.byte[ DWORD_3_PLACE ] = i.byte[ 3 ];

    return  o.int4;
#else
    return  aInt4;
#endif
}

// --------------------------------------------------------------------
// EOF: CIOConvert.cxx
// --------------------------------------------------------------------
