// --------------------------------------------------------------------
// CIOConvert.hxx
// Whatis:  Conversion between internal and external representations
//          of integers
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CIOConvert_hxx
#define CIOConvert_hxx
#include    "Platform.hxx"  // Platform specific declarations

// --------------------------------------------------------------------
// Class declaration of CIOConvert
// --------------------------------------------------------------------
class CIOConvert {

    // ----------------------------------------------------------------
    public:     // Constructor and destructor just dummies
    // ----------------------------------------------------------------
    CIOConvert  () {}
    ~CIOConvert () {}

    // ----------------------------------------------------------------
    public:     // Conversion routines ... functionality depends ...
                // Import methods are used to convert into local
                // presentation and Export methods do the opposite
    // ----------------------------------------------------------------
    word_t      Import ( word_t  ) const;
    dword_t     Import ( dword_t ) const;
    int2_t      Import ( int2_t  ) const;
    int4_t      Import ( int4_t  ) const;
    float       Import ( float )   const;

    word_t      Export ( word_t  ) const;
    dword_t     Export ( dword_t ) const;
    int2_t      Export ( int2_t  ) const;
    int4_t      Export ( int4_t  ) const;
    float       Export ( float )   const;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CIOConvert    CIOConvert_t;

#endif  // #ifndef CIOConvert_hxx
// --------------------------------------------------------------------
// EOF: CIOConvert.hxx
// --------------------------------------------------------------------
