// --------------------------------------------------------------------
// CUnNameTable.cxx
// Whatis:  Unreal Name
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CUnNameTable.hxx"

// --------------------------------------------------------------------
// public:      Constructor
// --------------------------------------------------------------------
CUnNameTable::CUnNameTable ( CUnFile & aUf ) {
    CUnNameTable::Cleanup();
	try {
	    itsNameList = new CUnName_t [ aUf.NameCount() ];
	    if  ( ! itsNameList )   throw CError( "Out of memory" );
	
	    aUf.Seek( aUf.NameOffset() );
	
	    while   ( itsNameCount < aUf.NameCount() ) {
			CUnName	name( aUf );
	        itsNameList[itsNameCount++] = name;
	    }
	}
	catch ( CError e ) {
	    if  ( itsNameList ) delete [] itsNameList;
    	CUnNameTable::Cleanup();
		throw CError( "CUnNameTable::CUnNameTable", e.Error() );
	}
	catch ( ... ) {
	    if  ( itsNameList ) delete [] itsNameList;
    	CUnNameTable::Cleanup();
		throw;
	}
}

// --------------------------------------------------------------------
// public:      Destructor
// --------------------------------------------------------------------
CUnNameTable::~CUnNameTable () {
    if  ( itsNameList ) delete [] itsNameList;
    CUnNameTable::Cleanup();
}

// --------------------------------------------------------------------
// public:      Interface - Name by index
// --------------------------------------------------------------------
const char *            CUnNameTable::Name ( dword_t aIndex ) const {
    return aIndex < itsNameCount ? itsNameList[aIndex].Name() : "";
}

// --------------------------------------------------------------------
// public:      Interface - Name by index (lowercase)
// --------------------------------------------------------------------
const char *            CUnNameTable::LcName ( dword_t aIndex ) const {
    return aIndex < itsNameCount ? itsNameList[aIndex].LcName() : "";
}

// --------------------------------------------------------------------
// public:      Interface - Name by name
// --------------------------------------------------------------------
const char *            CUnNameTable::Name ( const char * aName ) const {
    return  CUnNameTable::Name( CUnNameTable::Find ( aName ) );
}

// --------------------------------------------------------------------
// public:      Interface - Flags by index
// --------------------------------------------------------------------
const CUnObjectFlags_t  CUnNameTable::Flags ( dword_t aIndex ) const {
    return  aIndex < itsNameCount ? itsNameList[aIndex].Flags() : CUnObjectFlags();
}
 
// --------------------------------------------------------------------
// public:      Interface - Flags by name
// --------------------------------------------------------------------
const CUnObjectFlags_t CUnNameTable::Flags ( const char * aName ) const {
    return  CUnNameTable::Flags( CUnNameTable::Find ( aName ) );
}

// --------------------------------------------------------------------
// public:      Interface - Check existence by name
// --------------------------------------------------------------------
bool                    CUnNameTable::Exist ( const char * aName ) const {
    return  CUnNameTable::Find( aName ) < itsNameCount;
}

// --------------------------------------------------------------------
// public:      Interface - Index by name
// --------------------------------------------------------------------
dword_t                 CUnNameTable::Find ( const char * aName ) const {
    char *  name = NULL;
    dword_t loop = 0;
    try {
        name = ::my_strlower( ::my_private_strdup( aName ) );

        for ( loop = 0; loop < itsNameCount; loop++ ) {
            if  ( ! ::strcmp( name, itsNameList[loop].LcName() ) )  break;
        }
    }

    catch   ( ... ) {
        if  ( name ) delete [] name;
        name = NULL;
        throw;
    }
    delete [] name;

    return loop;    
}

// --------------------------------------------------------------------
// private:     Cleenex
// --------------------------------------------------------------------
void    CUnNameTable::Cleanup( void ) {
    itsNameList  = NULL;
    itsNameCount = 0;
}

// --------------------------------------------------------------------
dword_t	CUnNameTable::Count   ( void ) const { return itsNameCount; }

// --------------------------------------------------------------------
// EOF: CUnNameTable.cxx
// --------------------------------------------------------------------
