// --------------------------------------------------------------------
// PlatStr.cxx
// Whatis:  Some general string routines that are often needed but not supported
//          by ANSI C
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#include    "Platform.hxx"

// --------------------------------------------------------------------
// Macros for converting case
// --------------------------------------------------------------------
#define LOWERCASE(c)    (((c) <= 'Z') && ((c) >= 'A') ? ((c) + ('a' - 'A')) : (c))
#define UPPERCASE(c)    (((c) <= 'z') && ((c) >= 'a') ? ((c) - ('a' - 'A')) : (c))

// --------------------------------------------------------------------
// Convert a string to lowercase
// --------------------------------------------------------------------
extern  char *  my_strlower( char * aS ) {
	if	( aS ) {
	    char * p = aS;
    	while   ( *p ) { *p = (char)(LOWERCASE( *p )); p++; }
	}
    return  aS;
}

// --------------------------------------------------------------------
// Convert a string to uppercase
// --------------------------------------------------------------------
extern  char *  my_strupper( char * aS ) {
	if	( aS ) {
	    char * p = aS;
    	while   ( *p ) { *p = (char)(UPPERCASE( *p )); p++; }
	}
    return  aS;
}

// --------------------------------------------------------------------
// Duplicate a string
// --------------------------------------------------------------------
extern  char *  my_private_strdup( const char * aS ) {
    if  ( ! aS )    return NULL;
    char * p = new char [ ::strlen( aS ) + 1 ];
    ::strcpy( p, aS );
    return p;
}

// --------------------------------------------------------------------
// Remove leading spaces
// --------------------------------------------------------------------
extern  char *  my_strhead( char * aS ) {
	if	( aS ) {
	    char *  p = aS;
    	while   ( ( *p > 0 ) && ( *p <= ' ' ) ) p++;
    	if  ( aS != p ) ::strcpy( aS, p );
	}
    return  aS;
}

// --------------------------------------------------------------------
// Remove trailing spaces
// --------------------------------------------------------------------
extern  char *  my_strtail( char * aS ) {
	if	( aS ) {
	    int p = ::strlen( aS );
    	while   ( ( p >= 0 ) && ( aS[p] >= 0 ) && ( aS[p] <= ' ' ) )    aS[p--] = 0;
	}
    return  aS;
}

// --------------------------------------------------------------------
// Remove both trailing and leading spaces
// --------------------------------------------------------------------
extern  char *  my_strfix( char * aS ) {
    return  ::my_strhead( ::my_strtail( aS ) );
}

// --------------------------------------------------------------------
// Compare strings, ignore case
// --------------------------------------------------------------------
extern  int     my_stricmp( const char * aS1, const char * aS2 ) {
    const char *    p1 = aS1;
    const char *    p2 = aS2;

	if	( ( p1 ) && ( p2 ) ) {
	    while   ( (*p1) && (*p2) ) {
	        char    c1 = (char)(LOWERCASE( *p1 ));
	        char    c2 = (char)(LOWERCASE( *p2 ));
	        if  ( c1 > c2 ) return  1;
	        if  ( c1 < c2 ) return -1;
	        p1++; p2++;
	    }
	    if  ( ( *p1 ) && ( *p2 == 0 ) )     return  1;
	    if  ( ( *p1 == 0 ) && ( *p2 ) )     return -1;
	}
	else if	( p1 )	return	1;
	else if	( p2 )	return	-1;
    return  0;
}

// --------------------------------------------------------------------
// Copy string but check space first
// --------------------------------------------------------------------
extern  char *	my_strfit( char * aB, size_t aL, const char * aS ) {
	if	( ( aB ) && ( aS ) ) {
	    if  ( ::strlen( aS ) > aL - 1 ) {
	        ::memcpy( aB, aS, aL - 1 );
	        aB[aL - 1] = 0;
	    }
	    else {
	        ::strcpy( aB, aS );
	    }
	}
	return	aB;
}

// --------------------------------------------------------------------
// public:      Parse a string to output
// --------------------------------------------------------------------
extern  void	my_parse(	parse_ask_fun_tp    aCallback,
                            const char *        aString ) {
    char            b[1024];
    long            l;
    const char *    s;
    const char *    e;

    while   ( *aString ) {
        if  ( ::strncmp( "<!--?", aString, 5 ) ) {
            putchar( *(aString++) );
            continue;
        }

        s = aString + 5;
        e = ::strstr( s, "-->" );

        if  ( ! e ) {
            putchar( *(aString++) );
            continue;
        }
        l = (long)e - (long)s;

        if  ( ( l > 1000 ) || ( l < 0 ) ) {
            putchar( *(aString++) );
            continue;
        }

        ::memcpy( b, s, l+1 );
        b[l] = 0;
        aCallback( b );
        aString = e + 3;
    }
}

// --------------------------------------------------------------------
// public:      Default answer
// --------------------------------------------------------------------
extern	void	my_default_answer	( const char * aQ ) {
}

// --------------------------------------------------------------------
// EOF: PlatStr.cxx
// --------------------------------------------------------------------
