// --------------------------------------------------------------------
// Platform.hxx
// Whatis:  General platform dependant declarations and definitions
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef Platform_hxx
#define Platform_hxx

// -----------------------------------------------------------------------
// We classify the borland compiler as WIN32 compliant
// -----------------------------------------------------------------------
#ifndef	WIN32
#ifdef	__BORLANDC__
#define	WIN32
#endif
#endif

// -----------------------------------------------------------------------
// This define helps to distinguish meaningless warnings on some cases
// -----------------------------------------------------------------------
#define FOREVER     while ( 1 )

// -----------------------------------------------------------------------
// The following define enables multithreading
// -----------------------------------------------------------------------
#ifndef _MT
#define _MT
#endif

// -----------------------------------------------------------------------
// Setting up some compiler flags (skipping insane warnings)
// -----------------------------------------------------------------------
#ifdef  WIN32
#ifndef	__BORLANDC__
// #pragma warning ( disable : 4100 4127 4201 4245 4514 4786 4663 )
#pragma warning ( disable : 4100 4190 )
#endif
#endif

// -----------------------------------------------------------------------
// Most often needed system includes.
// -----------------------------------------------------------------------
#ifdef  WIN32

#include    <cstdlib>
#include    <cstdio>
#include    <cstring>
#include    <cmath>
#include    <list>

using namespace std;

#include    <time.h>
#include    <errno.h>
#include    <signal.h>
#include    <sys/stat.h>
#ifdef		__BORLANDC__
#include    <utime.h>
#else
#include    <sys/utime.h>
#endif
#include	<direct.h>

#else

#include    <stdio.h>
#include    <string>
#include    <list>
#include    <errno.h>
#include    <time.h>

#include    <unistd.h>
#include    <sys/time.h>
#include    <sys/wait.h>
#include    <stdlib.h>
#include    <utime.h>
#include	<fcntl.h>
#include    <sys/stat.h>
#include    <sys/types.h>

using namespace std;

#endif


#include    "Probe.h"   // An include file created by the Probe utility

// -----------------------------------------------------------------------
// Some very commonly used STL declarations
// -----------------------------------------------------------------------
typedef list <word_t>               word_tl;
typedef word_tl::iterator           word_tli;
typedef word_tl::const_iterator     word_tlci;

typedef list <dword_t>              dword_tl;
typedef dword_tl::iterator          dword_tli;
typedef dword_tl::const_iterator    dword_tlci;

typedef list <int2_t>               int2_tl;
typedef int2_tl::iterator           int2_tli;
typedef int2_tl::const_iterator     int2_tlci;

typedef list <int4_t>               int4_tl;
typedef int4_tl::iterator           int4_tli;
typedef int4_tl::const_iterator     int4_tlci;

typedef list <byte_tp>              byte_tpl;
typedef byte_tpl::iterator          byte_tpli;
typedef byte_tpl::const_iterator    byte_tplci;

// -----------------------------------------------------------------------
// List of files, returned by my_dir
// -----------------------------------------------------------------------
typedef struct {
    char    name    [128];  // File name
}   dir_file_t,
*   dir_file_tp,
**  dir_file_th;

typedef list <dir_file_t>               dir_file_tl;
typedef dir_file_tl::iterator           dir_file_tli;
typedef dir_file_tl::const_iterator     dir_file_tlci;

// --------------------------------------------------------------------
// public:	The sleep macro
// --------------------------------------------------------------------
#ifdef	WIN32
#define	SLEEP(x)	SleepEx( (x), FALSE );
#else
#define	SLEEP(x)	sleep((x)/1000 );
#endif

// --------------------------------------------------------------------
// public:	Platform dependant functions
// --------------------------------------------------------------------
#ifdef  __cplusplus
extern "C" {
#endif


// String manipulation
typedef void    (*parse_ask_fun_tp)( const char * aWhat );
extern  char *  my_strlower	( char * aS );
extern  char *  my_strupper	( char * aS );
extern  char *  my_private_strdup	( const char * aS );
extern  char *  my_strhead	( char * aS );
extern  char *  my_strtail	( char * aS );
extern  char *  my_strfix	( char * aS );
extern  int     my_stricmp	( const char * aS1, const char * aS2 );
extern  char *  my_strfit	( char * aB, size_t aL, const char * aS );

// Parsing
extern  void	my_parse	( parse_ask_fun_tp    aCallback,
                              const char *        aString );
extern	void	my_default_answer	( const char * );

// Encryption / Decryption
extern  char *	my_encrypt  ( char * aB );
extern	char *	my_decrypt  ( char * aB );

// Printing time
extern  const char *    my_time_string  ( time_t aTime );

// Directory listing and pathname manipulation
extern  dir_file_tl 	my_private_dir	( const char * aDir, bool aAll );
extern  void    		my_extract_file	( char * aFname, size_t aLen, const char * aPathname );
extern  void    		my_strip_suffix	( char * aFilename );

// Temporary directory management
extern  void    my_make_tempdir     ( char * aTempdir, const char * aRoot );
extern  void    my_erase_tempdir    ( const char * aTempdir );

// HTTP head output
extern  void	HTTP_html	( const char * aLanguage );
extern  void	HTTP_text	( const char * aLanguage );
extern  void	HTTP_image	( const char * aImageType, dword_t aImageLength );
extern  void	HTTP_mime	( const char * aMimeType,  dword_t aImageLength );
extern  void	HTTP_ziphead( dword_t aStartOffset, dword_t aEndOffset, dword_t aTotalLength );
extern  void    HTTP_cookie	( const char * aName,
							  const char * aValue,
							  const char * aPath,
							  const char * aComment );

extern  void	HTTP_kill_cookie(	const char *	aName,
									const char *	aValue,
									const char *	aPath );

extern  void    HTML_quote	( const char * aText );
extern  void    HTML_quotec	( char  aChar );
extern  void    CGI_quote	( const char * aText );

// Read in an entire file
extern	char *	my_load_file ( const char * aFileName );

// Creating ZIP files
extern	void	my_make_zip	 ( const char * aZipName,
							   const char * aSource );

#ifdef  __cplusplus
}
#endif

#endif  // #ifndef Platform_hxx
// --------------------------------------------------------------------
// EOF: Platform.hxx
// --------------------------------------------------------------------
