// --------------------------------------------------------------------
// CUpDoc.h
// Whatis:  UnrPack Document class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpDoc_h
#define CUpDoc_h

#include	"CUpFile.h"
#include	"CUpInput.h"
#include	"CUpFileType.h"
#include	"CUpString.h"
#include	"CUpMemo.h"

#include	"CCpuMutex.hxx"
#include	"CZipNotification.hxx"

// --------------------------------------------------------------------
class CUpDoc {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpDoc		();
	~CUpDoc		();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator are invalid
	// ----------------------------------------------------------------
	CUpDoc				( const CUpDoc & );
	CUpDoc & operator =	( const CUpDoc & );

	// ----------------------------------------------------------------
	public:		//	Methods used for locking the document for threads
	// ----------------------------------------------------------------
    void				Lock			( void );
    void				Unlock			( void );
	const char *		ProgressMessage	( void ) const;
	dword_t				ProgressOffs	( void ) const;
    dword_t				ProgressSize	( void ) const;
	bool				ProgressDone	( void ) const;
    CZipNotification &	ZipProgress		( void );

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( const char * ) const;
	void				Read		( const char * );
	void				NewDoc		( const char * );
    void				DefaultPaths( const char * aUtRoot );

	// ----------------------------------------------------------------
	public:		// Archivers
	// ----------------------------------------------------------------
	char *				GenerateReadme		( void ) const;
	void				SetArchiveFileName	( const char * );
    void				WriteIntoZip		( void );
    void				WriteIntoGZip		( void );
    void				WriteIntoUz			( void );
    const char *		UccPath				( int aMode ) const;
    const char *		UccExecutable		( int aMode ) const;
    bool				CanUseUz1			( void ) const;
    bool				UzAvailable			( void ) const;

	// ----------------------------------------------------------------
	public:		// Managing the file type list CUpDocFileTypeList.cpp
	// ----------------------------------------------------------------
	void				FileTypeListInsert	( const CUpFileType & );
    void				FileTypeListDelete	( const char * );
    void				FileTypeListUpdate	( const char *, const CUpFileType & );
    CUpFileType			FileTypeListItem	( const char * ) const;
    bool				FileTypeListExist	( const char * ) const;
    void				FileTypeListUp		( const char * );
    void				FileTypeListDown	( const char * );
    void				FileTypeListSelect	( const char *, bool );
    bool				FileTypeListSelect	( const char * ) const;
    const CUpFileType_l &	FileTypeList		( void ) const;
    void				FileTypeListWrite	( CWinIniFile & ) const;
    void				FileTypeListRead	( const CWinIniFile & );

	// ----------------------------------------------------------------
	public:		// Managing the path list CUpDocPathList.cpp
	// ----------------------------------------------------------------
	void				PathListInsert	( const char * );
    void				PathListDelete	( const char * );
    bool				PathListExist	( const char * ) const;
    void				PathListUp		( const char * );
    void				PathListDown	( const char * );
    void				PathListSelect	( const char *, bool );
    bool				PathListSelect	( const char * ) const;
    const CUpString_l &	PathList		( void ) const;
    void				PathListWrite	( CWinIniSection & ) const;
    void				PathListRead	( const CWinIniFile & );

	// ----------------------------------------------------------------
	public:		// Managing the deny list CUpDocDenyList.cpp
	// ----------------------------------------------------------------
	void				DenyListInsert	( const char * );
    void				DenyListDelete	( const char * );
    bool				DenyListExist	( const char * ) const;
    void				DenyListSelect	( const char *, bool );
    bool				DenyListSelect	( const char * ) const;
    const CUpString_l &	DenyList		( void ) const;
    void				DenyListWrite	( CWinIniSection & ) const;
    void				DenyListRead	( const CWinIniFile & );

	// ----------------------------------------------------------------
	public:		// Managing the input list CUpDocInputList.cpp
	// ----------------------------------------------------------------
	void				InputListClear	( void );
	void				InputListInsert	( const CUpInput & );
    void				InputListDelete	( const char * );
    bool				InputListExist	( const char * ) const;
    CUpInput			InputListItem	( const char * ) const;
    void				InputListSelect	( const char *, bool );
    bool				InputListSelect	( const char * ) const;
    const CUpInput_l &	InputList		( void ) const;
    void				InputListWrite	( CWinIniFile & ) const;
    void				InputListRead	( const CWinIniFile & );
    void				AddInputFile	( const char * );
    bool				IsDeniedFile	( const char * );
    void				FindMissingPacks( void );
    CUpInput			InputListMapFile( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    bool				Dirty			( void ) const;
    CUpFile &     		ProjectFile		( void );
    int					ZipPathMode		( void ) const;
    int					ZipCompressMode	( void ) const;
    const char *        ZipComment		( void ) const;
    int					GZipPathMode	( void ) const;
    int					GZipCompressMode( void ) const;
    const char *        GZipComment		( void ) const;
    const char *		ReadmeName		( void ) const;
    const char *		ReadmeEmail		( void ) const;
    const char *		ReadmeWebsite	( void ) const;
    int					ReadmeNaming	( void ) const;
    const char *		ReadmeFileName	( void ) const;
    bool				ReadmeHtml		( void ) const;
    const char *		ReadmeText		( void ) const;
    const char *		UzRepository	( void ) const;
    const char *		Uz2Repository	( void ) const;
    int					UzMode			( void ) const;
    bool				UzSkipNoPack	( void ) const;
    bool				UzIncremental	( void ) const;
	const char *		FtpMirIp		( void ) const;
	unsigned short		FtpMirPort		( void ) const;
    bool				FtpMirPasv		( void ) const;
	const char *		FtpMirLogin		( void ) const;
	const char *		FtpMirPassw		( void ) const;
	const char *		FtpMirServerRoot( void ) const;
	const char *		FtpMirLocalRoot	( void ) const;
    bool				FtpMirAdd		( void ) const;
    bool				FtpMirDel		( void ) const;
    bool				FtpMirMod		( void ) const;

	// ----------------------------------------------------------------
    void				Dirty			( bool );
    void				ZipPathMode		( int );
    void				ZipCompressMode	( int );
    void                ZipComment		( const char * );
    void				GZipPathMode	( int );
    void				GZipCompressMode( int );
    void                GZipComment		( const char * );
    void				ReadmeName		( const char * );
    void				ReadmeEmail		( const char * );
    void				ReadmeWebsite	( const char * );
    void				ReadmeNaming	( int );
    void				ReadmeFileName	( const char * );
    void				ReadmeHtml		( bool );
    void				ReadmeText		( const char * );
    void				UzRepository	( const char * );
    void				Uz2Repository	( const char * );
    void				UzMode			( int );
    void				UzSkipNoPack	( bool );
    void				UzIncremental	( bool );
	void				FtpMirIp		( const char * );
	void				FtpMirPort		( unsigned short );
    void				FtpMirPasv		( bool );
	void				FtpMirLogin		( const char * );
	void				FtpMirPassw		( const char * );
	void				FtpMirServerRoot( const char * );
	void				FtpMirLocalRoot	( const char * );
    void				FtpMirAdd		( bool );
    void				FtpMirDel		( bool );
    void				FtpMirMod		( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup		( void );
	void				Free		( void );
    char *				GenDate		( char * ) const;
    char *				GenYear		( char * ) const;
    char *				GenReadme	( char * ) const;
    char *				GenTitle	( char * ) const;
    char *				GenFdate	( char * ) const;
    char *				GenEnterTxt	( char * ) const;
    char *				GenMapFile	( char * ) const;
    char *				GenString	( char *, const char *, dword_t ) const;
    char *				GenAppend	( char *, const char * ) const;
    char *				GetReadme	( void ) const;

    void				RipIniFilePaths	( const char *, const char * );
    void				RipIniPath		( const char *, const char * );
	void				RegisterUcc		( CUpString &, CUpString &, const char * );
    void				UzCompress		( const char *, const char * );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    CUpString			itsUccPath;
    CUpString			itsUcc2Path;
    CUpString			itsUccExe;
    CUpString			itsUcc2Exe;
	bool				itsDirty;

	// ----------------------------------------------------------------
	// Project data
	// ----------------------------------------------------------------
    CUpFile				itsProjectFile;
    CUpString_l			itsPathList;
    CUpString_l			itsDenyList;
    CUpFileType_l		itsFileTypeList;
    CUpInput_l			itsInputList;
    int					itsZipPathMode;
    int					itsZipCompressMode;
    CUpMemo				itsZipComment;
    int					itsGZipPathMode;
    int					itsGZipCompressMode;
    CUpMemo				itsGZipComment;

	// ----------------------------------------------------------------
	// Doc progress
	// ----------------------------------------------------------------
	const char *		itsProgressMessage;
	dword_t				itsProgressOffs;
    dword_t				itsProgressSize;
	bool				itsProgressDone;
	CCpuMutex			itsMutex;

	// ----------------------------------------------------------------
	// Zip and GZip archives
	// ----------------------------------------------------------------
    CZipNotification	itsZipProgress;
    CUpFile				itsArchiveFile;

	// ----------------------------------------------------------------
	// UZ and UZ2 archives
	// ----------------------------------------------------------------
    CUpString			itsUzRepository;
    CUpString			itsUz2Repository;
    int					itsUzMode;
    bool				itsUzSkipNoPack;
    bool				itsUzIncremental;

	// ----------------------------------------------------------------
	// FTP Mirroring
	// ----------------------------------------------------------------
	CUpString			itsFtpMirIp;
	unsigned short		itsFtpMirPort;
    bool				itsFtpMirPasv;
	CUpString			itsFtpMirLogin;
	CUpString			itsFtpMirPassw;
	CUpString			itsFtpMirServerRoot;
	CUpString			itsFtpMirLocalRoot;
    bool				itsFtpMirAdd;
    bool				itsFtpMirDel;
    bool				itsFtpMirMod;

	// ----------------------------------------------------------------
	// Readme
	// ----------------------------------------------------------------
    CUpString			itsReadmeName;
    CUpString			itsReadmeEmail;
    CUpString			itsReadmeWebsite;
    int					itsReadmeNaming;
    CUpString			itsReadmeFileName;
    bool				itsReadmeHtml;
    CUpMemo				itsReadmeText;

};

#endif
// --------------------------------------------------------------------
// EOF:	CUpDoc.h
// --------------------------------------------------------------------
