// --------------------------------------------------------------------
// CUpString.h
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUpString_h
#define CUpString_h

#include	"IUpList.h"
#include	"CWinIniFile.hxx"

// --------------------------------------------------------------------
class CUpString : public IUpList {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUpString	();
	~CUpString	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUpString				( const CUpString & );
	CUpString & operator =	( const CUpString & );
	CUpString & operator =	( const char * );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const CUpString & ) const;
    bool operator == ( const char * ) const;
    bool operator != ( const CUpString & ) const;
    bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Interface for the list management
	// ----------------------------------------------------------------
	bool				ListSelect	( void ) const;
    void				ListSelect	( bool );
	const char *		ListName	( void ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void				Write		( CWinIniSection &, const char * ) const;
	void				Read		( const CWinIniFile &, const char *, const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *		Value	( void ) const;
	bool				Select	( void ) const;

	// ----------------------------------------------------------------
	void				Value	( const char * );
	void				Select	( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *				itsValue;
	bool				itsSelect;

};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUpString>		CUpString_l;
typedef CUpString_l::iterator       CUpString_li;
typedef CUpString_l::const_iterator	CUpString_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUpString.h
// --------------------------------------------------------------------
