// --------------------------------------------------------------------
// CUpDocArchive.cpp
// Whatis:  UnrPack Document class - Archiving
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpDoc.h"
#include	"CZip.hxx"
#include	"CTar.hxx"
#include	"zlib.h"
#include	"CUnFile.hxx"
#include	<process.h>

// --------------------------------------------------------------------
// public:	Archivers
// --------------------------------------------------------------------
void	CUpDoc::SetArchiveFileName	( const char * aFile ) {
	itsArchiveFile.PathName( aFile );
}

// --------------------------------------------------------------------
void	CUpDoc::WriteIntoZip		( void ) {
	struct stat	mystat;
	CZip		myzip;
	CZipFlags	myflags;
    char		direntry[512];
    bool		succeed;
    char *		readmedata;
    char *		readmefile;

	itsZipProgress.Task( "Writing files to Zip" );
	itsZipProgress.FileName( "" );
	itsZipProgress.TotalFiles( 0 );
	itsZipProgress.FilesDone( 0 );
	itsZipProgress.FileBytes( 0 );
	itsZipProgress.FileBytesDone( 0 );
	itsZipProgress.TotalBytes( 0 );
	itsZipProgress.TotalBytesDone( 0 );
	itsZipProgress.Aborting( false );
	itsZipProgress.Ready( false );

    readmedata = NULL;
    readmefile = NULL;

    // Loop through the input files and create entry for each
    CUpInput_lci	fileloop;
    for	( fileloop = itsInputList.begin(); fileloop != itsInputList.end(); fileloop++ ) {

    	// Skip files that are not selected
		if	( (*fileloop).Select() == false ) {
        	continue;
        }

		// Take file statistics - if fails we skip the file
        if	( ::stat( (*fileloop).File().PathName(), &mystat ) != 0 ) {
        	continue;
        }

		// Set directory entry name for the file
		if		( itsZipPathMode == 0 ) {	// Normal Unreal type path
        	::strcpy( direntry, (*fileloop).FileType().TargetDir() );
            ::strcat( direntry, "/" );
            ::strcat( direntry, (*fileloop).File().FullName() );
        }
        else if	( itsZipPathMode == 1 ) {	// Use full path (no drive or root)
        	::strcpy( direntry, (*fileloop).File().PathName() + 3 );
        }
        else if	( itsZipPathMode == 2 ) {	// No path information
        	::strcpy( direntry, (*fileloop).File().FullName() );
        }
        while	( ::strchr( direntry, '\\' ) ) {
        	*::strchr( direntry, '\\' ) = '/';
        }

        // Set up zip flags for this entry
		if		( itsZipCompressMode == 0 ) {	// Always full compression
			myflags.CompressionLevel( 9 );
        }
        else if	( itsZipCompressMode == 1 ) {	// Skip compression on compressed data
        	if		( ! ::stricmp( (*fileloop).File().Suffix(), ".gif" ) ) {
				myflags.CompressionLevel( 0 );
            }
        	else if	( ! ::stricmp( (*fileloop).File().Suffix(), ".jpg" ) ) {
				myflags.CompressionLevel( 0 );
            }
        	else if	( ! ::stricmp( (*fileloop).File().Suffix(), ".jpeg" ) ) {
				myflags.CompressionLevel( 0 );
            }
        	else if	( ! ::stricmp( (*fileloop).File().Suffix(), ".zip" ) ) {
				myflags.CompressionLevel( 0 );
            }
        	else if	( ! ::stricmp( (*fileloop).File().Suffix(), ".gz" ) ) {
				myflags.CompressionLevel( 0 );
            }
            else {
				myflags.CompressionLevel( 9 );
            }
        }
        else if	( itsZipCompressMode == 2 ) {	// Don't compress
			myflags.CompressionLevel( 0 );
		}

		// Add the entry to zip
        myzip.AddDirectoryEntry(    myflags,
        							(*fileloop).File().PathName(),
                                    direntry );

		// Update progress meters
		itsZipProgress.TotalFiles( itsZipProgress.TotalFiles() + 1 );
		itsZipProgress.TotalBytes( itsZipProgress.TotalBytes() + mystat.st_size );
    }

	// Do we need to create a readme on teh fly ?
	readmedata = CUpDoc::GenerateReadme();
    if	( readmedata ) {
        if	( itsZipCompressMode == 2 ) {
			myflags.CompressionLevel( 0 );
        }
        else {
			myflags.CompressionLevel( 9 );
        }

        readmefile = CUpDoc::GetReadme();
        if	( readmefile ) {
	   		if	( itsZipPathMode == 0 ) {
    	    	::sprintf( direntry, "Help/%s", readmefile );
        	}
	        else {
    	    	::strcpy( direntry, readmefile );
        	}
        }
		else if	( itsZipPathMode == 0 ) {
			::strcpy( direntry, "Help/Readme.txt" );
        }
        else {
			::strcpy( direntry, "Readme.txt" );
        }
		// Add the entry to zip
        myzip.AddDirectoryEntry(    myflags,
        							readmedata,
                                    (dword_t)::strlen( readmedata ),
                                    direntry );

		// Update progress meters
		itsZipProgress.TotalFiles( itsZipProgress.TotalFiles() + 1 );
		itsZipProgress.TotalBytes( itsZipProgress.TotalBytes() + ::strlen( readmedata ) );
    }

	// Do we have a zip comment ?
    if	( itsZipComment != "" ) {
    	myzip.AddZipComment( itsZipComment.Value() );
    }

    // Now, let it go to file
	succeed = false;
    try {
		myzip.Write( itsArchiveFile.PathName(), &itsZipProgress );
		if	( itsZipProgress.Aborting() == false ) {
        	succeed = true;
        }
    }

    catch	( ... ) {
    	succeed = false;
    }
	itsZipProgress.Ready( true );
	if	( ! succeed ) {
    	::unlink( itsArchiveFile.PathName() );
    }

    if	( readmedata ) delete [] readmedata;
    if	( readmefile ) delete [] readmefile;
}

// --------------------------------------------------------------------
void	CUpDoc::WriteIntoGZip		( void ) {
	struct stat	mystat;
	CTarFile_l	mytarlist;
    char		direntry[512];
    bool		succeed;
    char *		readmedata;
    char *		readmefile;

	itsZipProgress.Task( "Writing files to GZip" );
	itsZipProgress.FileName( "" );
	itsZipProgress.TotalFiles( 0 );
	itsZipProgress.FilesDone( 0 );
	itsZipProgress.FileBytes( 0 );
	itsZipProgress.FileBytesDone( 0 );
	itsZipProgress.TotalBytes( 0 );
	itsZipProgress.TotalBytesDone( 0 );
	itsZipProgress.Aborting( false );
	itsZipProgress.Ready( false );

    readmedata = NULL;
    readmefile = NULL;

    // Loop through the input files and create entry for each
    CUpInput_lci	fileloop;
    for	( fileloop = itsInputList.begin(); fileloop != itsInputList.end(); fileloop++ ) {

    	// Skip files that are not selected
		if	( (*fileloop).Select() == false ) {
        	continue;
        }

		// Take file statistics - if fails we skip the file
        if	( ::stat( (*fileloop).File().PathName(), &mystat ) != 0 ) {
        	continue;
        }

		// Set directory entry name for the file
		if		( itsGZipPathMode == 0 ) {	// Normal Unreal type path
        	::strcpy( direntry, (*fileloop).FileType().TargetDir() );
            ::strcat( direntry, "/" );
            ::strcat( direntry, (*fileloop).File().FullName() );
        }
        else if	( itsGZipPathMode == 1 ) {	// Use full path (no drive or root)
        	::strcpy( direntry, (*fileloop).File().PathName() + 3 );
        }
        else if	( itsGZipPathMode == 2 ) {	// No path information
        	::strcpy( direntry, (*fileloop).File().FullName() );
        }
        while	( ::strchr( direntry, '\\' ) ) {
        	*::strchr( direntry, '\\' ) = '/';
        }

		// Add another entry for the tar list
        CTarFile	mytarentry( (*fileloop).File().PathName(), direntry );
        mytarlist.push_back( mytarentry );
    }

	// Do we need to create a readme on teh fly ?
	readmedata = CUpDoc::GenerateReadme();
    if	( readmedata ) {
        readmefile = CUpDoc::GetReadme();
        if	( readmefile ) {
	   		if	( itsZipPathMode == 0 ) {
    	    	::sprintf( direntry, "Help/%s", readmefile );
        	}
	        else {
    	    	::strcpy( direntry, readmefile );
        	}
        }
		else if	( itsZipPathMode == 0 ) {
			::strcpy( direntry, "Help/Readme.txt" );
        }
        else {
			::strcpy( direntry, "Readme.txt" );
        }

        CTarFile	mytarentry( 	(byte_t *)readmedata,
        							(dword_t)::strlen( readmedata ),
                                    direntry );
        mytarlist.push_back( mytarentry );

		// Update progress meters
		itsZipProgress.TotalFiles( itsZipProgress.TotalFiles() + 1 );
		itsZipProgress.TotalBytes( itsZipProgress.TotalBytes() + ::strlen( readmedata ) );
    }

	// Do we have a zip comment ?
    if	( itsGZipComment != "" ) {
        CTarFile	mytarentry( 	(byte_t *)itsGZipComment.Value(),
        							(dword_t)::strlen( itsGZipComment.Value() ),
                                    "ReadmeTar.txt" );
        mytarlist.push_back( mytarentry );

		// Update progress meters
		itsZipProgress.TotalFiles( itsZipProgress.TotalFiles() + 1 );
		itsZipProgress.TotalBytes( itsZipProgress.TotalBytes() + ::strlen( itsGZipComment.Value() ) );
    }

    // Now, let it go to file
	succeed = false;
    try {
		CTar	mytar( mytarlist );

        // Now - let's see how we make this happen ...
        if	( itsGZipCompressMode == 0 ) {	// Ordinary tar.gz
        	mytar.WriteTarGz( itsArchiveFile.PathName(), &itsZipProgress );
        }
        else {								// Tar only
        	mytar.WriteTar( itsArchiveFile.PathName(), &itsZipProgress );
        }
		if	( itsZipProgress.Aborting() == false ) {
        	succeed = true;
        }
    }

    catch	( ... ) {
    	succeed = false;
    }
	itsZipProgress.Ready( true );
	if	( ! succeed ) {
    	::unlink( itsArchiveFile.PathName() );
    }

    if	( readmedata ) delete [] readmedata;
    if	( readmefile ) delete [] readmefile;
}

// --------------------------------------------------------------------
void	CUpDoc::WriteIntoUz		( void ) {
	struct stat		mystat;
    char			uzfile[512];
    CUpInput_lci	fileloop;

	itsZipProgress.Task( "UZ Compression" );
	itsZipProgress.FileName( "" );
	itsZipProgress.TotalFiles( 0 );
	itsZipProgress.FilesDone( 0 );
	itsZipProgress.FileBytes( 0 );
	itsZipProgress.FileBytesDone( 0 );
	itsZipProgress.TotalBytes( 0 );
	itsZipProgress.TotalBytesDone( 0 );
	itsZipProgress.Aborting( false );
	itsZipProgress.Ready( false );

    // Loop through the input files and collect some data
    for	( fileloop = itsInputList.begin(); fileloop != itsInputList.end(); fileloop++ ) {

    	// Skip files that are not selected
		if	( (*fileloop).Select() == false ) {
        	continue;
        }

		// Take file statistics - if fails we skip the file
        if	( ::stat( (*fileloop).File().PathName(), &mystat ) != 0 ) {
        	continue;
        }

		// Update progress meters
		itsZipProgress.TotalFiles( itsZipProgress.TotalFiles() + 1 );
		itsZipProgress.TotalBytes( itsZipProgress.TotalBytes() + mystat.st_size );
    }

    // Now, do the actual compression
    for	( fileloop = itsInputList.begin(); fileloop != itsInputList.end(); fileloop++ ) {

		// If aborted - we bail off from here
		if	( itsZipProgress.Aborting() ) {
        	break;
        }

    	// Skip files that are not selected
		if	( (*fileloop).Select() == false ) {
        	continue;
        }

		// Take file statistics - if fails we skip the file
        if	( ::stat( (*fileloop).File().PathName(), &mystat ) != 0 ) {
        	continue;
        }

		// Should we skip files that are not unreal packages ?
		if	( itsUzSkipNoPack ) {
        	bool	isunreal = false;

            try {
            	CUnFile	unf( (*fileloop).File().PathName() );
                isunreal = true;
            }
            catch ( ... ) {
            }

			if	( ! isunreal ) {
				itsZipProgress.FilesDone( itsZipProgress.FilesDone() + 1 );
				itsZipProgress.TotalBytesDone( itsZipProgress.TotalBytesDone() + mystat.st_size );
                continue;
            }
        }

        // Construct name for the target uz file
        ::sprintf( 	uzfile, "%s\\%s.%s",
                    itsUzMode == 0 ? itsUzRepository.Value() : itsUz2Repository.Value(),
					(*fileloop).File().FullName(),
					itsUzMode == 0 ? "uz" : "uz2" );

		// Should we skip files that are intact ?
		if	( itsUzIncremental ) {
			struct stat uzstat;
            if	( ::stat( uzfile, &uzstat ) == 0 ) {
            	if	( uzstat.st_mtime == mystat.st_mtime ) {
					itsZipProgress.FilesDone( itsZipProgress.FilesDone() + 1 );
					itsZipProgress.TotalBytesDone( itsZipProgress.TotalBytesDone() + mystat.st_size );
        	        continue;
                }
            }
		}

        // Do the actual processing
		itsZipProgress.FileName( uzfile );
        CUpDoc::UzCompress( (*fileloop).File().PathName(), uzfile );
		itsZipProgress.FilesDone( itsZipProgress.FilesDone() + 1 );
		itsZipProgress.TotalBytesDone( itsZipProgress.TotalBytesDone() + mystat.st_size );
    }

	itsZipProgress.Ready( true );
}

// --------------------------------------------------------------------
// private:		Do UZ compression
// --------------------------------------------------------------------
void	CUpDoc::UzCompress	( const char * aFile, const char * aUz ) {
	BOOL				result;
    char				cmdline	[1024];
    STARTUPINFO			mystartup;
	PROCESS_INFORMATION	myinfo;
    struct stat			mystat;
    time_t				reftime;

    ::sprintf( cmdline, "\"%s\" compress \"%s\"", CUpDoc::UccExecutable( itsUzMode ), aFile );

    GetStartupInfo( &mystartup );
    mystartup.lpReserved		= NULL;
    mystartup.lpDesktop			= NULL;
    mystartup.lpTitle			= NULL;
    mystartup.dwFlags			= STARTF_USESHOWWINDOW;
    mystartup.wShowWindow		= SW_HIDE;

	result = CreateProcess(	CUpDoc::UccExecutable( itsUzMode ),
    						cmdline,
                            NULL, NULL,
                            FALSE,
                            CREATE_DEFAULT_ERROR_MODE |
							DETACHED_PROCESS |
                            NORMAL_PRIORITY_CLASS,
                            NULL,
                            CUpDoc::UccPath( itsUzMode ),
                            &mystartup,
                            &myinfo );
	if	( result != 0 ) {
    	DWORD	mycode;
		reftime = ::time( NULL ) + 300;	// Must be ready in 5 minutes
        while	( GetExitCodeProcess( myinfo.hProcess, &mycode ) != 0 ) {
			SLEEP( 100 );
			if	( mycode != STILL_ACTIVE )	break;
			if	( ::time( NULL ) > reftime ) {
				TerminateProcess( myinfo.hProcess, 0 );
            }
			if	( itsZipProgress.Aborting() ) {
            	reftime = ::time( NULL ) - 1;
            }
        }
    }

    // Next - we move the file into the new location
    ::strcpy( cmdline, aFile );
    ::strcat( cmdline, itsUzMode == 0 ? ".uz" : ".uz2" );
    if	( ::time( NULL ) > reftime ) {
    	::unlink( cmdline );
    }

	if	( ::stricmp( cmdline, aUz ) ) {
		if	( ::stat( cmdline, &mystat ) == 0 ) {
    	    char	d1[10];
        	char	d2[10];
	        ::fnsplit( cmdline, d1, NULL, NULL, NULL );
    	    ::fnsplit( aUz, d2, NULL, NULL, NULL );
           	::unlink( aUz );

	        if	( ::stricmp( d1, d2 ) ) {
            	FILE *	f1	= ::fopen( cmdline, "rb" );
                FILE *	f2	= ::fopen( aUz, "wb" );
                int		ch;
				if	( ( f1 ) && ( f2 ) ) {
                	while	( ! feof( f1 ) ) {
                    	ch = ::fgetc( f1 );
                        if	( ch >= 0 ) {
	                    	::fputc( ch, f2 );
                        }
                    }
                }
                if	( f1 )	::fclose( f1 );
                if	( f2 )	::fclose( f2 );
    	    }
        	else {
				::rename( cmdline, aUz );
    		}
            ::unlink( cmdline );

            // Last but not least - set the modification time same as original file
            struct utimbuf 	utb;
            ::stat( aFile, &mystat );
            utb.actime 	= mystat.st_atime;
            utb.modtime	= mystat.st_mtime;
            ::utime( aUz, &utb );
    	}
    }
}

// --------------------------------------------------------------------
// EOF:	CUpDocArchive.cpp
// --------------------------------------------------------------------
