// --------------------------------------------------------------------
// CUpDocFileTypeList.cpp
// Whatis:  UnrPack Document class - Path list management
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpDoc.h"

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListInsert	( const CUpFileType & aC ) {
	if	( ! CUpDoc::FileTypeListExist( aC.Name() ) ) {
        itsFileTypeList.push_back( aC );
        itsDirty = true;
    }
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListDelete	( const char * aType ) {
	if	( CUpDoc::FileTypeListExist( aType ) ) {
		CUpFileType_li	loop;
	    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
        	if	( ! ::stricmp( aType, (*loop).Name() ) ) {

			    // Remove files that use this file type as well !
        		CUpInput_li	file;
                file = itsInputList.begin();
                while	( file != itsInputList.end() ) {
        			if	( (*file).FileType() == *loop ) {
                    	CUpInput	myinput = *file;
						CUpDoc::InputListDelete( myinput.File().PathName() );
		                file = itsInputList.begin();
                    }
                    else {
                    	file++;
                    }
		        }

            	itsFileTypeList.remove( *loop );

		        itsDirty = true;
                return;
            }
	    }
    }
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListUpdate	( const char * aType, const CUpFileType & aC ) {
	if	( CUpDoc::FileTypeListExist( aType ) ) {
		CUpFileType_li	loop;
	    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
        	if	( ! ::stricmp( aType, (*loop).Name() ) ) {

			    // Remove files that use this file type as well !
        		CUpInput_li	file;
                file = itsInputList.begin();
                while	( file != itsInputList.end() ) {
        			if	( (*file).FileType() == *loop ) {
                    	CUpInput	myinput = *file;
						CUpDoc::InputListDelete( myinput.File().PathName() );
		                file = itsInputList.begin();
                    }
                    else {
                    	file++;
                    }
		        }

				*loop = aC;
		        itsDirty = true;
                return;
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::FileTypeListExist	( const char * aType ) const {
	CUpFileType_lci	loop;
    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
    	if	( ! ::stricmp( aType, (*loop).Name() ) )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CUpFileType	CUpDoc::FileTypeListItem	( const char * aType ) const {
	CUpFileType_lci	loop;
    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
    	if	( ! ::stricmp( aType, (*loop).Name() ) )	return *loop;
    }
    CUpFileType	mytype;
    return mytype;
}

// --------------------------------------------------------------------
const CUpFileType_l &	CUpDoc::FileTypeList ( void ) const {
	return itsFileTypeList;
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListWrite	( CWinIniFile & aIni ) const {
	CUpFileType_lci	loop;
	CWinIniSection	sec;
    int				secnumber;

	sec.Name( "FileTypeList" );
    sec.Insert( "Count", (int)itsFileTypeList.size() );
	aIni.Insert( sec );

	secnumber = 1;
	for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
		char	secname[32];
        ::sprintf( secname, "FileType_%d", secnumber++ );
        sec.Clear();
        sec.Name( secname );
		(*loop).Write( sec );
		aIni.Insert( sec );
	}
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListRead	( const CWinIniFile & aIni ) {
	dword_t	typecount;
	dword_t	typenumber;

	typecount = aIni.IntValue( "FileTypeList", "Count" );

    for	( typenumber = 1; typenumber <= typecount; typenumber++ ) {
		char	secname[32];
        ::sprintf( secname, "FileType_%d", typenumber );
        CUpFileType	mytype;
        mytype.Read( aIni, secname );
		if	( ! CUpDoc::FileTypeListExist( mytype.Name() ) ) {
	        itsFileTypeList.push_back( mytype );
        }
        else {
        	CUpDoc::FileTypeListSelect( mytype.Name(), mytype.Select() );
        }
    }
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListSelect	( const char * aType, bool aSel ) {
	if	( CUpDoc::FileTypeListExist( aType ) ) {
		if	( CUpDoc::FileTypeListSelect( aType ) != aSel ) {
			CUpFileType_li	loop;
		    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
        		if	( ! ::stricmp( aType, (*loop).Name() ) ) {
            		(*loop).Select( aSel );
		        	itsDirty = true;
	                return;
    	        }
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::FileTypeListSelect	( const char * aType ) const {
	CUpFileType_lci	loop;
    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
    	if	( ! ::stricmp( aType, (*loop).Name() ) )	return (*loop).Select();
    }
    return false;
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListUp		( const char * aType ) {
	int				indx;
    CUpFileType_li	loop;

    for	( indx = 0, loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); indx++, loop++ ) {
    	if	( ! ::stricmp( aType, (*loop).Name() ) ) break;
    }
    if	( loop == itsFileTypeList.end() )	return;
    if	( indx == 0 )					return;

    CUpFileType	mytype = *loop;
	itsFileTypeList.remove( *loop );

    loop = itsFileTypeList.begin();
    while	( indx > 1 ) {
    	loop++;
        indx--;
    }
	itsFileTypeList.insert( loop, mytype );
	itsDirty = true;
}

// --------------------------------------------------------------------
void	CUpDoc::FileTypeListDown	( const char * aType ) {
	int				indx;
    CUpFileType_li	loop;

    for	( indx = 0, loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); indx++, loop++ ) {
    	if	( ! ::stricmp( aType, (*loop).Name() ) ) break;
    }
    if	( loop == itsFileTypeList.end() )			return;
    if	( indx == (int)itsFileTypeList.size() - 1 )	return;

    CUpFileType	mytype = *loop;
	itsFileTypeList.remove( *loop );

    loop = itsFileTypeList.begin();
    while	( indx > -1 ) {
    	loop++;
        indx--;
    }
	itsFileTypeList.insert( loop, mytype );
	itsDirty = true;
}

// --------------------------------------------------------------------
// EOF:	CUpDocFileTypeList.cpp
// --------------------------------------------------------------------