// --------------------------------------------------------------------
// CUpDocInputList.cpp
// Whatis:  UnrPack Document class - Input list management
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpDoc.h"
#include	"CUnUtils.hxx"
#include	"CUnLevelInfo.hxx"

// --------------------------------------------------------------------
void	CUpDoc::InputListClear	( void ) {
    itsDirty = true;
	itsInputList.clear();
}

// --------------------------------------------------------------------
void	CUpDoc::InputListInsert	( const CUpInput & aInput ) {
	if	( ! CUpDoc::InputListExist( aInput.File().PathName() ) ) {
        itsInputList.push_back( aInput );
        itsDirty = true;
    }
}

// --------------------------------------------------------------------
void	CUpDoc::InputListDelete	( const char * aPath ) {
	if	( CUpDoc::InputListExist( aPath ) ) {
		CUpInput_li	loop;
	    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
        	if	( (*loop).File().SameFile( aPath ) ) {
            	itsInputList.remove( *loop );
		        itsDirty = true;
                return;
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::InputListExist	( const char * aPath ) const {
	CUpInput_lci	loop;
    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
    	if	( (*loop).File().SameFile( aPath ) )	return true;
    }
    return false;
}

// --------------------------------------------------------------------
CUpInput	CUpDoc::InputListMapFile( void ) const {
	CUpInput_lci	loop;
    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
		if	( (*loop).FileType().PaneLevel() )	return *loop;
    }
    CUpInput	myinput;
    return myinput;
}

// --------------------------------------------------------------------
CUpInput	CUpDoc::InputListItem	( const char * aPath ) const {
	CUpInput_lci	loop;
    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
    	if	( (*loop).File().SameFile( aPath ) )	return *loop;
    }
    CUpInput	myinput;
    return myinput;
}

// --------------------------------------------------------------------
const CUpInput_l &	CUpDoc::InputList ( void ) const {
	return itsInputList;
}

// --------------------------------------------------------------------
void	CUpDoc::InputListWrite	( CWinIniFile & aIni ) const {
	CUpInput_lci	loop;
	CWinIniSection	sec;
    int				secnumber;

	sec.Name( "InputList" );
    sec.Insert( "Count", (int)itsInputList.size() );
	aIni.Insert( sec );

	secnumber = 1;
	for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
		char	secname[32];
        ::sprintf( secname, "Input_%d", secnumber++ );
        sec.Clear();
        sec.Name( secname );
		(*loop).Write( sec );
		aIni.Insert( sec );
	}
}

// --------------------------------------------------------------------
void	CUpDoc::InputListRead	( const CWinIniFile & aIni ) {
	dword_t		typecount;
	dword_t		typenumber;
	CUpInput_li	loop;

	typecount = aIni.IntValue( "InputList", "Count" );

    for	( typenumber = 1; typenumber <= typecount; typenumber++ ) {
		char	secname[32];
        ::sprintf( secname, "Input_%d", typenumber );
        CUpInput	myinput;
        myinput.Read( aIni, secname );
        itsInputList.push_back( myinput );
    }

    // After reading the list is somewhat incomplete - we must fill
    // the file types in !
    loop = itsInputList.begin();
	while	( loop != itsInputList.end() ) {
    	if	( CUpDoc::FileTypeListExist( (*loop).FileType().Name() ) ) {
			(*loop).FileType( CUpDoc::FileTypeListItem( (*loop).FileType().Name() ) );
			loop++;
        }
        else {
        	itsInputList.remove( *loop );
		    loop = itsInputList.begin();
        }
    }
}

// --------------------------------------------------------------------
void	CUpDoc::InputListSelect	( const char * aPath, bool aSel ) {
	if	( CUpDoc::InputListExist( aPath ) ) {
		if	( CUpDoc::InputListSelect( aPath ) != aSel ) {
			CUpInput_li	loop;
		    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
        		if	( (*loop).File().SameFile( aPath ) ) {
            		(*loop).Select( aSel );
		        	itsDirty = true;
	                return;
    	        }
            }
	    }
    }
}

// --------------------------------------------------------------------
bool	CUpDoc::InputListSelect	( const char * aPath ) const {
	CUpInput_lci	loop;
    for	( loop = itsInputList.begin(); loop != itsInputList.end(); loop++ ) {
    	if	( (*loop).File().SameFile( aPath ) )	return (*loop).Select();
    }
    return false;
}

// --------------------------------------------------------------------
void	CUpDoc::AddInputFile	( const char * aPath ) {
    // Is the file already in our list ?
    if	( CUpDoc::InputListExist( aPath ) )	return;

	// Is this a denied file ?
	if	( CUpDoc::IsDeniedFile( aPath ) )	return;

    // Detect the file type
    CUpFileType_lci	loop;
    for	( loop = itsFileTypeList.begin(); loop != itsFileTypeList.end(); loop++ ) {
    	if	( (*loop).Select() == false )	continue;
    	if	( (*loop).Detect( aPath ) )		break;
    }

    // Unable to detect file type ?
    if	( loop == itsFileTypeList.end() )	return;

    // Ok, we are ready to go !
	CUpFile		myfile;
	CUpInput	myinput;

    myfile.PathName( aPath );
    myinput.File( myfile );
    myinput.FileType( *loop );
    myinput.Select( true );
    itsInputList.push_back( myinput );
    itsDirty = true;
}

// --------------------------------------------------------------------
bool	CUpDoc::IsDeniedFile	( const char * aPath ) {
	char	filename[256];
   	::fnsplit( aPath, NULL, NULL, filename, NULL );
    ::strlwr( filename );
	CUpString_lci	loop;
	for	( loop = itsDenyList.begin(); loop != itsDenyList.end(); loop++ ) {
   		if	( (*loop).Select() == false )	continue;
       	if	( ! ::stricmp( (*loop).Value(), filename ) )	return true;
	}
    return	false;
}

// --------------------------------------------------------------------
void	CUpDoc::FindMissingPacks	( void ) {
	unr_package_tl	packlist;
	unr_package_tli	packloop;
	CUpInput_lci	fileloop;
    CUpString_lci	pathloop;
    char			filename[512];
    char *			filesuff;
    const char *	suff;
    char *			tail;
    int				rmbsize;

	CUpDoc::Lock();
    itsProgressSize = itsInputList.size();
    itsProgressOffs = 0;
	itsProgressDone	= false;
    CUpDoc::Unlock();

	// Loop through the entire input list
    for	( fileloop = itsInputList.begin(); fileloop != itsInputList.end(); fileloop++ ) {

		CUpDoc::Lock();
		itsProgressOffs++;
        CUpDoc::Unlock();

		// If the file is not selected we should skip it
        if	( (*fileloop).Select() == false )	continue;

		// First get list of packages this file needs
       	packlist.clear();
		if	( (*fileloop).FileType().AutoSearch() ) {
			try {
            	CUnUtils	utl( (*fileloop).File().PathName() );
				packlist = utl.ImportList();
    	    }
        	catch ( ... ) {
            	packlist.clear();
	        }
    	}

        // There is still a possibility that this file needs ogg audio file
        // Let's see if there is one for it !
        if	( ! ::stricmp( (*fileloop).File().Suffix(), ".ut2" ) ) {
			try	{
				CUnFile			unf( (*fileloop).File().PathName() );
                CUnNameTable    ntb( unf );
                CUnExportTable	etb( unf );
                CUnImportTable	itb( unf );
                CUnLevelInfo	lvl( unf, ntb, etb, itb );
                if	( lvl.Audio()[0] != 0 ) {
					unr_package_t	package;
                    ::strcpy( package.name, lvl.Audio() );
                    packlist.push_back( package );
                }
            }
            catch	( ... ) {
            }
        }

   		// For each pack, use all paths
		for	( pathloop = itsPathList.begin(); pathloop != itsPathList.end(); pathloop++ ) {

        	// If the path is not selected we should skip it !
            if	( (*pathloop).Select() == false )	continue;

			// Go through all the packages
    	    for	( packloop = packlist.begin(); packloop != packlist.end(); packloop++ ) {

				CUpDoc::Lock();
                itsProgressMessage = filename;
				::strcpy( filename, (*pathloop).Value() );
                ::strcat( filename, "\\" );
                ::strcat( filename, (*packloop).name );
                filesuff = filename + ::strlen( filename );
		        CUpDoc::Unlock();

                // Now, loop through all suffixes from file type
				suff = (*fileloop).FileType().Suffixes();
                while	( (*suff) && (*suff != '.') )	suff++;
				while	( *suff == '.' ) {

                    // Put the suffix on back of the file name
			        CUpDoc::Lock();
					::strcpy( filesuff, suff );

                	// Remove extra stuff
                    tail = filesuff + 1;
                    while	( ( *tail ) &&
                    		  ( (*tail < 0) || (*tail > ' ') ) &&
                    		  (*tail != '.' ) )	tail++;
                	*tail = 0;
			        CUpDoc::Unlock();

					// Try to add the resulting file
                    rmbsize = itsInputList.size();
					CUpDoc::AddInputFile( filename );

                    // If we succeeded in resolving the need - we skip rest of the suffixes
                    if	( rmbsize < (int)itsInputList.size() )	break;

					// Advance to next dot or end of suffixes
                    suff++;
                    while	( (*suff) && (*suff != '.') )	suff++;
                }
            }
        }
    }
    CUpDoc::Lock();
    itsProgressMessage = "";
    itsProgressDone	   = true;
    CUpDoc::Unlock();
}

// --------------------------------------------------------------------
// EOF:	CUpDocInputList.cpp
// --------------------------------------------------------------------