// --------------------------------------------------------------------
// CUpDocReadme.cpp
// --------------------------------------------------------------------
#include	"CUpDoc.h"
#include	"CUnLevelInfo.hxx"

// --------------------------------------------------------------------
// public:	Generating the readme file text
// --------------------------------------------------------------------
char *	CUpDoc::GenerateReadme ( void ) const {
	const char *	tempdata;
    const char *	nexttag;
    char *			result;

    tempdata	= itsReadmeText.Value();
    result		= NULL;
    while	( tempdata ) {
       	nexttag = ::strstr( tempdata, "<!--?" );
		if	( nexttag ) {
        	result = CUpDoc::GenString( result, tempdata, (dword_t)nexttag - (dword_t)tempdata );
            if		( ! ::strnicmp( nexttag, "<!--?ReadmeFileName-->", 22 ) ) {
				result = CUpDoc::GenReadme( result );
                tempdata = nexttag + 22;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?GameTitle-->", 17 ) ) {
				result = CUpDoc::GenTitle( result );
                tempdata = nexttag + 17;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?Author-->", 14 ) ) {
				result = CUpDoc::GenAppend( result, itsReadmeName.Value() );
                tempdata = nexttag + 14;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?Email-->", 13 ) ) {
				result = CUpDoc::GenAppend( result, itsReadmeEmail.Value() );
                tempdata = nexttag + 13;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?Website-->", 15 ) ) {
				result = CUpDoc::GenAppend( result, itsReadmeWebsite.Value() );
                tempdata = nexttag + 15;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?FileDate-->", 16 ) ) {
            	result = CUpDoc::GenFdate( result );
                tempdata = nexttag + 16;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?Today-->", 13 ) ) {
            	result = CUpDoc::GenDate( result );
                tempdata = nexttag + 13;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?EnterText-->", 17 ) ) {
            	result = CUpDoc::GenEnterTxt( result );
                tempdata = nexttag + 17;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?MapFile-->", 15 ) ) {
            	result = CUpDoc::GenMapFile( result );
                tempdata = nexttag + 15;
            }
            else if	( ! ::strnicmp( nexttag, "<!--?Year-->", 12 ) ) {
            	result = CUpDoc::GenYear( result );
                tempdata = nexttag + 12;
            }
			else {
	        	result = CUpDoc::GenString( result, nexttag, 5 );
                tempdata = nexttag + 5;
            }
        }
        else {
        	result = CUpDoc::GenString( result, tempdata, ::strlen( tempdata ) );
            tempdata = NULL;
        }
	}
	return	result;
}

// --------------------------------------------------------------------
// private:	Generate diverse data
// --------------------------------------------------------------------
char *	CUpDoc::GenDate( char * aS ) const {
	char	datestr[32];
    time_t	timenow;
    timenow = ::time( NULL );
    ::strcpy( datestr, ::ctime( &timenow ) );
    ::my_strfix( datestr );
    return	CUpDoc::GenAppend( aS, datestr );
}

// --------------------------------------------------------------------
char *	CUpDoc::GenYear( char * aS ) const {
	char	datestr[32];
    time_t	timenow;
    struct tm *	mytm;

    timenow = ::time( NULL );
	mytm = ::localtime( &timenow );
    ::sprintf( datestr, "%d", mytm->tm_year + 1900 );
    return	CUpDoc::GenAppend( aS, datestr );
}

// --------------------------------------------------------------------
char *	CUpDoc::GenReadme	( char * aS ) const {
	char * readmename = CUpDoc::GetReadme();
	if	( readmename ) {
		aS = CUpDoc::GenAppend( aS, readmename );
        delete [] readmename;
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenTitle	( char * aS ) const {
	CUpInput	myinput;
	myinput = CUpDoc::InputListMapFile();
    if	( myinput.FileType().PaneLevel() ) {
		try {
			CUnFile			unf( myinput.File().PathName() );
            CUnNameTable    ntb( unf );
            CUnExportTable	etb( unf );
            CUnImportTable	itb( unf );
            CUnLevelInfo	lvl( unf, ntb, etb, itb );

			aS = CUpDoc::GenAppend( aS, lvl.Title() );
        }
        catch	( ... ) {
        }
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenFdate	( char * aS ) const {
	CUpInput	myinput;
	struct stat	mystat;
	char	datestr[32];

	myinput = CUpDoc::InputListMapFile();
    if	( myinput.FileType().PaneLevel() ) {
		if	( ::stat( myinput.File().PathName(), &mystat ) == 0 ) {
		    ::strcpy( datestr, ::ctime( &mystat.st_mtime ) );
		    ::my_strfix( datestr );
			aS = CUpDoc::GenAppend( aS, datestr );
        }
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenEnterTxt	( char * aS ) const {
	CUpInput		myinput;
	const char *	etext;
    const char *	wrap;

	myinput = CUpDoc::InputListMapFile();
    if	( myinput.FileType().PaneLevel() ) {
		try {
			CUnFile			unf( myinput.File().PathName() );
            CUnNameTable    ntb( unf );
            CUnExportTable	etb( unf );
            CUnImportTable	itb( unf );
            CUnLevelInfo	lvl( unf, ntb, etb, itb );
			etext = lvl.EnterText();

            // Word wrap after column 70
            while	( etext ) {
				if	( ::strlen( etext ) < 80 ) {
					aS = CUpDoc::GenAppend( aS, etext );
                	etext = NULL;
                }
				else {
					wrap = etext + 70;
					while	( ( *wrap < 0 ) || ( *wrap > ' ' ) )	wrap++;

                    if	( *wrap ) {
			        	aS = CUpDoc::GenString( aS, etext, (dword_t)wrap - (dword_t)etext );
						aS = CUpDoc::GenAppend( aS, "\r\n" );
						etext = wrap + 1;
                    }
                    else {
						aS = CUpDoc::GenAppend( aS, etext );
    	            	etext = NULL;
                    }
                }
            }

        }
        catch	( ... ) {
        }
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenMapFile	( char * aS ) const {
	CUpInput	myinput;
	myinput = CUpDoc::InputListMapFile();
    if	( myinput.FileType().PaneLevel() ) {
		aS = CUpDoc::GenAppend( aS, myinput.File().FullName() );
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenString	( char * aS, const char * aD, dword_t aL ) const {
	int		nlcount;
    int		indx;
    int		wix;
    char *	tmp;

    // No data so just go away !
    if	( aL == 0 )	return aS;

    // Count number of newlines in the data to be inserted
    // This is done because we replace them with \r\n sequence
    for	( indx = 0, nlcount = 0; indx < (int)aL; indx++ ) {
		if	( aD[indx] == '\n' )	nlcount++;
    }

	// Allocate a temporary buffer
	tmp = new char [ ::strlen( aS ? aS : "" ) + aL + nlcount + 1 ];

    // Put the data into the buffer
    ::strcpy( tmp, aS ? aS : "" );
    wix = ::strlen( aS ? aS : "" );
    for	( indx = 0; indx < (int)aL; indx++ ) {
    	if	( aD[indx] =='\n' ) {
        	tmp[wix++] = '\r';
        	tmp[wix++] = '\n';
        }
        else {
        	tmp[wix++] = aD[indx];
        }
    }
	tmp[wix] = 0;
	if	( aS )	delete [] aS;
	return	tmp;
}

// --------------------------------------------------------------------
char *	CUpDoc::GenAppend( char * aS, const char * aD ) const {
	if	( aD ) {
		if	( aD[0] ) {
			if	( aS == NULL ) {
				aS = ::my_private_strdup( aD );
		    }
    		else {
    			char *	tmp;
		        tmp = new char [ ::strlen( aS ) + ::strlen( aD ) + 1 ];
    		    ::strcpy( tmp, aS );
        		::strcat( tmp, aD );
	        	delete [] aS;
	    	    aS = tmp;
		    }
        }
    }
	return	aS;
}

// --------------------------------------------------------------------
char *	CUpDoc::GetReadme( void ) const {
	CUpInput	myinput;
	char *		result;

    result = NULL;
	switch	( itsReadmeNaming ) {
    	case	0:	// Automatic
		myinput = CUpDoc::InputListMapFile();
		if	( myinput.FileType().PaneLevel() ) {
        	result = new char [ ::strlen( myinput.File().FileName() ) + 6 ];
			::sprintf( result, "%s%s", myinput.File().FileName(), itsReadmeHtml ? ".html" : ".txt" );
        }
        break;

        case	1:	// None
        result = NULL;
        break;

        case	2:	// Manual
		if	( itsReadmeFileName != "" ) {
        	result = new char [ ::strlen( itsReadmeFileName.Value() ) + 6 ];
			::sprintf( result, "%s%s", itsReadmeFileName.Value(), itsReadmeHtml ? ".html" : ".txt" );
        }
        break;
    }


	return	result;
}

// --------------------------------------------------------------------
// EOF: CUpDocReadme.cpp
// --------------------------------------------------------------------
