// --------------------------------------------------------------------
// CUpMemo.cpp
// Whatis:  Memo manipulation
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#include	"CUpMemo.h"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CUpMemo::CUpMemo	() {
	CUpMemo::Cleanup();
}

// --------------------------------------------------------------------
CUpMemo::~CUpMemo	() {
	CUpMemo::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CUpMemo::CUpMemo			( const CUpMemo & aC )  {
	CUpMemo::Cleanup();
	*this = aC;
}

// --------------------------------------------------------------------
CUpMemo & CUpMemo::operator =	( const CUpMemo & aC ) {
	CUpMemo::Free();
	CUpMemo::Value( aC.Value() );
	return *this;
}

// --------------------------------------------------------------------
CUpMemo & CUpMemo::operator =	( const char * aS ) {
	CUpMemo::Free();
	CUpMemo::Value( aS );
	return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operators
// --------------------------------------------------------------------
bool CUpMemo::operator == ( const CUpMemo & aC ) const {
	return ::strcmp( CUpMemo::Value(), aC.Value() ) == 0;
}

// --------------------------------------------------------------------
bool CUpMemo::operator == ( const char * aS ) const {
	return ::strcmp( CUpMemo::Value(), aS ? aS : "" ) == 0;
}

// --------------------------------------------------------------------
bool CUpMemo::operator != ( const CUpMemo & aC ) const {
	return ::strcmp( CUpMemo::Value(), aC.Value() ) != 0;
}

// --------------------------------------------------------------------
bool CUpMemo::operator != ( const char * aS ) const {
	return ::strcmp( CUpMemo::Value(), aS ? aS : "" ) != 0;
}

// --------------------------------------------------------------------
// public:	Streaming
// --------------------------------------------------------------------
void	CUpMemo::Write		( CWinIniSection & aSec, const char * aItemName ) const {
	CWinIniItem		itm;
    const char *	data;
   	const char *	end;
    dword_t			copylen;
    char *			copy;

    itm.Name( aItemName );
    data = CUpMemo::Value();
    copy = NULL;
    while	( *data ) {
		end = ::strchr( data, '\n' );
        if	( end == NULL ) end = data + ::strlen( data );

        copylen = (dword_t)end - (dword_t)data;
		if	( copy ) delete [] copy;
        copy = new char [copylen + 2];

        copy[0] = '-';
        ::memcpy( copy + 1, data, copylen );
        copy[copylen+1] = 0;

        itm.Value( copy );
		aSec.Insert( itm );

		if	( *end == '\n' )	data = end + 1;
        else					data = end;
    }
}

// --------------------------------------------------------------------
void	CUpMemo::Read		( const CWinIniFile & aIni, const char * aSecName, const char * aItemName ) {
	CWinIniItem_l	list;
    CWinIniItem_li	loop;
    dword_t			datalen;
	CUpMemo::Free();

    list = aIni.ItemList( aSecName, aItemName );
    if	( list.size() == 0 )	return;

	datalen = 0;
    for	( loop = list.begin(); loop != list.end(); loop++ ) {
    	if	( (*loop).Value()[0] == '-' ) {
	    	datalen = datalen + ::strlen( (*loop).Value() );
        }
    }
    if	( datalen == 0 )	return;

    itsValue = new char [ datalen + 1 ];
    *itsValue = 0;

    for	( loop = list.begin(); loop != list.end(); loop++ ) {
    	if	( (*loop).Value()[0] == '-' ) {
	    	::strcat( itsValue, (*loop).Value() + 1 );
            ::strcat( itsValue, "\n" );
        }
    }
}

// --------------------------------------------------------------------
// public:	Accessing instance data
// --------------------------------------------------------------------
const char *	CUpMemo::Value	( void ) const { return itsValue ? itsValue : ""; }

// --------------------------------------------------------------------
void			CUpMemo::Value	( const char * aV ) {
	CUpMemo::Free();
	if	( aV == NULL )	return;
	if	( *aV == 0 )	return;
	itsValue = ::my_private_strdup( aV );

    char *	mark;

    mark = ::strstr( itsValue, "\r\n" );
    while	( mark != NULL ) {
    	::strcpy( mark, mark + 1 );
	    mark = ::strstr( itsValue, "\r\n" );
    }

    mark = ::strstr( itsValue, "\n\r" );
    while	( mark != NULL ) {
    	::strcpy( mark + 1, mark + 2 );
	    mark = ::strstr( itsValue, "\n\r" );
    }

    mark = ::strchr( itsValue, '\r' );
    while	( mark != NULL ) {
		*mark = '\n';
	    mark = ::strchr( itsValue, '\r' );
    }
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void	CUpMemo::Free	( void ) {
	if	( itsValue )	delete [] itsValue;
	CUpMemo::Cleanup();
}

// --------------------------------------------------------------------
void	CUpMemo::Cleanup( void ) {
	itsValue = NULL;
}

// --------------------------------------------------------------------
// EOF:	CUpMemo.cpp
// --------------------------------------------------------------------
