//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpAddFilesDialog.h"
#include "TUpDialog.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TUpAddFilesDialog *UpAddFilesDialog = NULL;

//---------------------------------------------------------------------------
// local:	Thread for package searcher
//---------------------------------------------------------------------------
static int	__fastcall	MyPackageLoader( void * aDoc ) {
	CUpDoc *	myDoc = (CUpDoc *)aDoc;
    myDoc->FindMissingPacks();
    return	0;
}

//---------------------------------------------------------------------------
__fastcall TUpAddFilesDialog::TUpAddFilesDialog(TComponent* Owner)
	: TForm(Owner)
{
	itsDoc = NULL;
	itsUpdateFlag = 0;
	AddButton->Enabled = false;
}

//---------------------------------------------------------------------------
void __fastcall TUpAddFilesDialog::AddButtonClick(TObject *Sender)
{	// Add files
	int		itix;
	if	( itsDoc == NULL )	return;

    for	( itix = 0; itix < FileListBox->Items->Count; itix++ ) {
		if	(  FileListBox->Selected[itix] ) {
			char	filepath[256];
			::strcpy( filepath, FileListBox->Directory.c_str() );
            ::strcat( filepath, "\\" );
            ::strcat( filepath, FileListBox->Items->Strings[itix].c_str() );
			itsDoc->AddInputFile( filepath );
        }
    }
	UpDialog->DocumentProgress( MyPackageLoader, "Searching for packages" );
    UpDialog->Populate( NULL );
}

//---------------------------------------------------------------------------
void __fastcall TUpAddFilesDialog::FileListBoxChange(TObject *Sender)
{
	char	filepath[256];

	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;

	int		item;
    for	( item = 0; item < FileListBox->Items->Count; item++ ) {
		if	(  FileListBox->Selected[item] ) {
			::strcpy( filepath, FileListBox->Directory.c_str() );
            ::strcat( filepath, "\\" );
            ::strcat( filepath, FileListBox->Items->Strings[item].c_str() );
			if	( itsDoc->IsDeniedFile( filepath ) ) {
				FileListBox->Selected[item] = false;
            }
		}
    }

	AddButton->Enabled = FileListBox->SelCount > 0;
	if		( FileListBox->SelCount < 1 ) {
    	FileNamePanel->Caption = "Select and add files";
    }
    else if ( FileListBox->SelCount == 1 ) {
		FileNamePanel->Caption = FileListBox->Items->Strings[FileListBox->ItemIndex];
    }
    else {
    	FileNamePanel->Caption = "Multiple files";
    }
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
