//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"

//---------------------------------------------------------------------------
#define	SELITEM(l)		l->Items->Strings[l->ItemIndex].c_str()
#define	IDXITEM(l,i)	l->Items->Strings[i].c_str()
#define	IDXIREF(l,i)	l->Items->Strings[i]

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TUpDialog *UpDialog;

//---------------------------------------------------------------------------
void __fastcall TUpDialog::MyIdleHandler (TObject * Sender, bool & Done ) {
	Done = false;
	if	( PageControl->ActivePage == PageControl->Pages[4] ) {
		TUpDialog::PopulateMirror( Sender );
    }
    SLEEP( 10 );
}

//---------------------------------------------------------------------------
__fastcall TUpDialog::TUpDialog(TComponent* Owner)
	: TForm(Owner)
{
	// Reset all page controls to first page
	itsUpdateFlag	= 1;
    itsDoDirectory	= false;
    itsDoRefresh	= false;
    itsDoPwd		= false;
    itsDoDownload	= false;
    itsDoUpload		= false;
	PageControl->ActivePage						= PageControl->Pages[0];
	ProjectPageControl->ActivePage				= ProjectPageControl->Pages[0];
	FilesPageControl->ActivePage				= FilesPageControl->Pages[0];
	ArchivePageControl->ActivePage				= ArchivePageControl->Pages[0];
	FilesUnrealPageControl->ActivePage			= FilesUnrealPageControl->Pages[0];
	itsUpdateFlag	= 0;
    itsDumpOffset	= 0;
    itsDumpSize		= 0;
    itsShotOffset	= 0;

	itsDoc.NewDoc( Application->ExeName.c_str() );

	Application->OnIdle = MyIdleHandler;

	// Update everything
	TUpDialog::Populate( NULL );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::Populate( TObject *Sender ) {
	if	( itsUpdateFlag )	return;
    itsUpdateFlag++;
    TUpDialog::PageControlChange( Sender );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FormCloseQuery(TObject *Sender, bool &CanClose)
{	// Comes here before closing - may be canceled
	if	( itsDoc.Dirty() ) {
    	CanClose = TUpDialog::CanDisposeChanges( "Exit Unreal Packer anyway ?" );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PageControlChange(TObject *Sender)
{	// Update as page changed
	if		( PageControl->ActivePage == PageControl->Pages[0] ) {
    	TUpDialog::PopulateProject( Sender );
    }
	else if	( PageControl->ActivePage == PageControl->Pages[1] ) {
    	TUpDialog::PopulateFiles( Sender );
    }
	else if	( PageControl->ActivePage == PageControl->Pages[2] ) {
    	TUpDialog::PopulateArchive( Sender );
    }
	else if	( PageControl->ActivePage == PageControl->Pages[3] ) {
    	TUpDialog::PopulateWizard( Sender );
    }
	else if	( PageControl->ActivePage == PageControl->Pages[4] ) {
		if	( Application->OnIdle == NULL ) {
        	Application->OnIdle = MyIdleHandler;
        }
    	TUpDialog::PopulateMirror( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateArchive(TObject *Sender)
{	// Populate archive leaf
	ArchiveProjectPanel->Caption	= itsDoc.ProjectFile().FullName();
    TUpDialog::ArchivePageControlChange( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::ArchivePageControlChange(TObject *Sender)
{	// Update as page changed
	if		( ArchivePageControl->ActivePage == ArchivePageControl->Pages[0] ) {
		TUpDialog::PopulateArchiveZip( Sender );
	}
	else if	( ArchivePageControl->ActivePage == ArchivePageControl->Pages[1] ) {
		TUpDialog::PopulateArchiveGZip( Sender );
	}
	else if	( ArchivePageControl->ActivePage == ArchivePageControl->Pages[2] ) {
		TUpDialog::PopulateArchiveUz( Sender );
	}
}

//---------------------------------------------------------------------------

