//---------------------------------------------------------------------------
// TUpDialogFiles.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"
#include "CCrc32.hxx"
#include "CUnLevelInfo.hxx"
#include "CUnUtils.hxx"
#include "TUpAddFilesDialog.h"

extern	"C" {
extern	dword_t adler32( dword_t, const char *, unsigned int );
}

//---------------------------------------------------------------------------
#define	SELITEM(l)		l->Items->Strings[l->ItemIndex].c_str()
#define	IDXITEM(l,i)	l->Items->Strings[i].c_str()
#define	IDXIREF(l,i)	l->Items->Strings[i]

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFiles(TObject *Sender)
{	// Populate files leaf

    TUpDialog::ManageCheckBoxList( FilesCheckListBox, &(itsDoc.InputList()) );

    bool	myEnable	= FilesCheckListBox->ItemIndex >= 0;

    FilesDeleteBitBtn->Enabled	= myEnable;
    FilesPageControl->Enabled	= myEnable;
    FilesAddBitBtn->Enabled		= itsDoc.FileTypeList().size() > 0;
    FilesProjectPanel->Caption	= itsDoc.ProjectFile().FullName();

	CUpInput	myinput;
	if	( myEnable ) {
    	myinput = itsDoc.InputListItem( SELITEM( FilesCheckListBox ) );
    }

    TUpDialog::FilesPageControlChange( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesPageControlChange(TObject *Sender)
{
	if		( FilesPageControl->ActivePage == FilesPageControl->Pages[0] ) {
    	TUpDialog::FilesUnrealPageControlChange( Sender );
	}
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[1] ) {
    	TUpDialog::PopulateFilesLevel( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[2] ) {
    	TUpDialog::PopulateFilesHex( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[3] ) {
    	TUpDialog::PopulateFilesShot( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[4] ) {
    	TUpDialog::PopulateFilesTextures( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[5] ) {
    	TUpDialog::PopulateFilesPicture( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[6] ) {
    	TUpDialog::PopulateFilesText( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[7] ) {
    	TUpDialog::PopulateFilesHtml( Sender );
    }
    else if	( FilesPageControl->ActivePage == FilesPageControl->Pages[8] ) {
    	TUpDialog::PopulateFilesFile( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesUnrealPageControlChange(TObject *Sender)
{
	if		( FilesUnrealPageControl->ActivePage == FilesUnrealPageControl->Pages[0] ) {
    	TUpDialog::PopulateFilesUnrealPackage( Sender );
	}
    else if	( FilesUnrealPageControl->ActivePage == FilesUnrealPageControl->Pages[1] ) {
    	TUpDialog::PopulateFilesUnrealNames( Sender );
    }
    else if	( FilesUnrealPageControl->ActivePage == FilesUnrealPageControl->Pages[2] ) {
    	TUpDialog::PopulateFilesUnrealExports( Sender );
    }
    else if	( FilesUnrealPageControl->ActivePage == FilesUnrealPageControl->Pages[3] ) {
    	TUpDialog::PopulateFilesUnrealImports( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesUnrealPackage(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
	try {

	    if	( ! myinput.FileType().PaneUnreal() )	throw 1;
    	CUnFile		unf( myinput.File().PathName() );

		TUpDialog::SetControlEnable( FilesUnrealPackageVersionPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealLicenseeModePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealPackageFlagsPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealAllowDownloadPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealClientOptionalPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealServerSideOnlyPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealBrokenLinksPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealUnsecurePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealNeedPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealSignaturePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealGuidPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealNameCountPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealNameOffsetPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportCountPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportOffsetPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealImportCountPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealImportOffsetPanel, true );

		TUpDialog::SetPanelValue( FilesUnrealPackageVersionPanel, unf.PackageVersion() );
		TUpDialog::SetPanelValue( FilesUnrealLicenseeModePanel, unf.LicenseeMode() );
		TUpDialog::SetPanelValueHex( FilesUnrealPackageFlagsPanel, unf.PackageFlags() );
		TUpDialog::SetPanelValue( FilesUnrealAllowDownloadPanel, unf.AllowDownload() );
		TUpDialog::SetPanelValue( FilesUnrealClientOptionalPanel, unf.ClientOptional() );
		TUpDialog::SetPanelValue( FilesUnrealServerSideOnlyPanel, unf.ServerSideOnly() );
		TUpDialog::SetPanelValue( FilesUnrealBrokenLinksPanel, unf.BrokenLinks() );
		TUpDialog::SetPanelValue( FilesUnrealUnsecurePanel, unf.Unsecure() );
		TUpDialog::SetPanelValue( FilesUnrealNeedPanel, unf.Need() );
		TUpDialog::SetPanelValueHex( FilesUnrealSignaturePanel, unf.Signature() );
		TUpDialog::SetPanelValue( FilesUnrealGuidPanel, unf.GUID() );
		TUpDialog::SetPanelValue( FilesUnrealNameCountPanel, unf.NameCount() );
		TUpDialog::SetPanelValue( FilesUnrealNameOffsetPanel, unf.NameOffset() );
		TUpDialog::SetPanelValue( FilesUnrealExportCountPanel, unf.ExportCount() );
		TUpDialog::SetPanelValue( FilesUnrealExportOffsetPanel, unf.ExportOffset() );
		TUpDialog::SetPanelValue( FilesUnrealImportCountPanel, unf.ImportCount() );
		TUpDialog::SetPanelValue( FilesUnrealImportOffsetPanel, unf.ImportOffset() );
    }
    catch	( ... ) {
		TUpDialog::SetControlEnable( FilesUnrealPackageVersionPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealLicenseeModePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealPackageFlagsPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealAllowDownloadPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealClientOptionalPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealServerSideOnlyPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealBrokenLinksPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealUnsecurePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealNeedPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealSignaturePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealGuidPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealNameCountPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealNameOffsetPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportCountPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportOffsetPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealImportCountPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealImportOffsetPanel, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesUnrealNames(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
	try {
	    if	( ! myinput.FileType().PaneUnreal() )	throw 1;
    	CUnFile			unf( myinput.File().PathName() );
        CUnNameTable    ntb( unf );

        if	( ntb.Count() == 0 )	throw 1;

		TUpDialog::SetControlEnable( FilesUnrealNamesListBox, true );
		TUpDialog::SetControlEnable( FilesUnrealNamesFlag1Panel, true );
		TUpDialog::SetControlEnable( FilesUnrealNamesFlag2Panel, true );

        dword_t		name;
        int			item;

		name = 0;
        item = 0;

	    // Update the list as long as there are items in both
    	while	( ( item < FilesUnrealNamesListBox->Items->Count ) && ( name < ntb.Count() ) ) {
	    	if	( ::strcmp( IDXITEM( FilesUnrealNamesListBox, item ), ntb.Name( name ) ) ) {
				IDXIREF( FilesUnrealNamesListBox, item ) = ntb.Name( name );
        	}
	        name++;
    	    item++;
	    }

		// Insert to the list as long as we have additional data
    	while	( name < ntb.Count() ) {
    		FilesUnrealNamesListBox->Items->Add( ntb.Name( name ) );
	        name++;
    	    item++;
	    }

		// Remove items as long as possible
    	while	( item < FilesUnrealNamesListBox->Items->Count ) {
    		FilesUnrealNamesListBox->Items->Delete( item );
	    }

		// Always select one !
        if	( FilesUnrealNamesListBox->ItemIndex >= FilesUnrealNamesListBox->Items->Count ) {
			FilesUnrealNamesListBox->ItemIndex = FilesUnrealNamesListBox->Items->Count - 1;
        }
        if	( FilesUnrealNamesListBox->ItemIndex < 0 ) {
        	FilesUnrealNamesListBox->ItemIndex = 0;
        }

		TUpDialog::DisplayObjectFlags(	FilesUnrealNamesFlag1Panel,
        								FilesUnrealNamesFlag2Panel,
                                        ntb.Flags( FilesUnrealNamesListBox->ItemIndex ) );
	}

    catch	( ... ) {
		TUpDialog::SetControlEnable( FilesUnrealNamesListBox, false );
		TUpDialog::SetControlEnable( FilesUnrealNamesFlag1Panel, false );
		TUpDialog::SetControlEnable( FilesUnrealNamesFlag2Panel, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesUnrealExports(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
	try {
	    if	( ! myinput.FileType().PaneUnreal() )	throw 1;
    	CUnFile			unf( myinput.File().PathName() );
        CUnNameTable    ntb( unf );
        CUnExportTable	etb( unf );
        CUnImportTable	itb( unf );

        if	( etb.Count() == 0 )	throw 1;

		TUpDialog::SetControlEnable( FilesUnrealExportsListBox, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsFlag1Panel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsFLag2Panel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsClassPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsSuperPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsPackagePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsSizePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealExportsOffsetPanel, true );

        dword_t		name;
        int			item;

		name = 0;
        item = 0;

	    // Update the list as long as there are items in both
    	while	( ( item < FilesUnrealExportsListBox->Items->Count ) && ( name < etb.Count() ) ) {
        	CUnExport	e;
            e = etb.Export( name );
	    	if	( ::strcmp( IDXITEM( FilesUnrealExportsListBox, item ), ntb.Name( e.ObjectName() ) ) ) {
				IDXIREF( FilesUnrealExportsListBox, item ) = ntb.Name( e.ObjectName() );
        	}
	        name++;
    	    item++;
	    }

		// Insert to the list as long as we have additional data
    	while	( name < etb.Count() ) {
        	CUnExport	e;
            e = etb.Export( name );
    		FilesUnrealExportsListBox->Items->Add( ntb.Name( e.ObjectName() ) );
	        name++;
    	    item++;
	    }

		// Remove items as long as possible
    	while	( item < FilesUnrealExportsListBox->Items->Count ) {
    		FilesUnrealExportsListBox->Items->Delete( item );
	    }

		// Always select one !
        if	( FilesUnrealExportsListBox->ItemIndex >= FilesUnrealExportsListBox->Items->Count ) {
			FilesUnrealExportsListBox->ItemIndex = FilesUnrealExportsListBox->Items->Count - 1;
        }
        if	( FilesUnrealExportsListBox->ItemIndex < 0 ) {
        	FilesUnrealExportsListBox->ItemIndex = 0;
        }

        CUnExport	exp	= etb.Export( FilesUnrealExportsListBox->ItemIndex );

		TUpDialog::DisplayObjectFlags(	FilesUnrealExportsFlag1Panel,
        								FilesUnrealExportsFLag2Panel,
                                        exp.Flags() );

		// Class
        if	( ISUNIMPORT( exp.Class() ) ) {
			TUpDialog::SetPanelValue( FilesUnrealExportsClassPanel, ntb.Name( itb.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() ) );
        }
        else {
			TUpDialog::SetPanelValue( FilesUnrealExportsClassPanel, ntb.Name( etb.Export( NAMEEXPORT( exp.Class() ) ).ObjectName() ) );
        }

        TUpDialog::SetPanelValueHex( FilesUnrealExportsSuperPanel,   exp.Super() );
        TUpDialog::SetPanelValueHex( FilesUnrealExportsPackagePanel, exp.Package() );
        TUpDialog::SetPanelValue( FilesUnrealExportsSizePanel, exp.SerialSize() );
        TUpDialog::SetPanelValue( FilesUnrealExportsOffsetPanel, exp.SerialOffset() );

	}
    catch	( ... ) {
		TUpDialog::SetControlEnable( FilesUnrealExportsListBox, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsFlag1Panel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsFLag2Panel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsClassPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsSuperPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsPackagePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsSizePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealExportsOffsetPanel, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesUnrealImports(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
	try {
	    if	( ! myinput.FileType().PaneUnreal() )	throw 1;
    	CUnFile			unf( myinput.File().PathName() );
        CUnNameTable    ntb( unf );
        CUnExportTable	etb( unf );
        CUnImportTable	itb( unf );

        if	( itb.Count() == 0 )	throw 1;

		TUpDialog::SetControlEnable( FilesUnrealImportsListBox, true );
		TUpDialog::SetControlEnable( FilesUnrealImportsClassPackPanel, true );
		TUpDialog::SetControlEnable( FilesUnrealImportsClassNamePanel, true );
		TUpDialog::SetControlEnable( FilesUnrealImportsPackagePanel, true );

        dword_t		name;
        int			item;

		name = 0;
        item = 0;

	    // Update the list as long as there are items in both
    	while	( ( item < FilesUnrealImportsListBox->Items->Count ) && ( name < itb.Count() ) ) {
        	CUnImport	i;
            i = itb.Import( name );
	    	if	( ::strcmp( IDXITEM( FilesUnrealImportsListBox, item ), ntb.Name( i.ObjectName() ) ) ) {
				IDXIREF( FilesUnrealImportsListBox, item ) = ntb.Name( i.ObjectName() );
        	}
	        name++;
    	    item++;
	    }

		// Insert to the list as long as we have additional data
    	while	( name < itb.Count() ) {
        	CUnImport	i;
            i = itb.Import( name );
    		FilesUnrealImportsListBox->Items->Add( ntb.Name( i.ObjectName() ) );
	        name++;
    	    item++;
	    }

		// Remove items as long as possible
    	while	( item < FilesUnrealImportsListBox->Items->Count ) {
    		FilesUnrealImportsListBox->Items->Delete( item );
	    }

		// Always select one !
        if	( FilesUnrealImportsListBox->ItemIndex >= FilesUnrealImportsListBox->Items->Count ) {
			FilesUnrealImportsListBox->ItemIndex = FilesUnrealImportsListBox->Items->Count - 1;
        }
        if	( FilesUnrealImportsListBox->ItemIndex < 0 ) {
        	FilesUnrealImportsListBox->ItemIndex = 0;
        }

        CUnImport	imp = itb.Import( FilesUnrealImportsListBox->ItemIndex );

        TUpDialog::SetPanelValue( FilesUnrealImportsClassPackPanel, ntb.Name( imp.ClassPackage() ) );
        TUpDialog::SetPanelValue( FilesUnrealImportsClassNamePanel, ntb.Name( imp.ClassName() ) );
		TUpDialog::SetPanelValue( FilesUnrealImportsPackagePanel, ntb.Name( itb.Import( NAMEIMPORT( imp.Package() ) ).ObjectName() ) );
    }

    catch ( ... ) {
		TUpDialog::SetControlEnable( FilesUnrealImportsListBox, false );
		TUpDialog::SetControlEnable( FilesUnrealImportsClassPackPanel, false );
		TUpDialog::SetControlEnable( FilesUnrealImportsClassNamePanel, false );
		TUpDialog::SetControlEnable( FilesUnrealImportsPackagePanel, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesLevel(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
    try	{
	    if	( ! myinput.FileType().PaneLevel() )	throw 1;

		CUnFile			unf( myinput.File().PathName() );
        CUnNameTable	ntb( unf );
        CUnExportTable	etb( unf );
        CUnImportTable	itb( unf );
        CUnLevelInfo	lvl( unf, ntb, etb, itb );

		TUpDialog::SetControlEnable( FilesLevelAuthorPanel, true );
		TUpDialog::SetControlEnable( FilesLevelTitlePanel, true );
		TUpDialog::SetControlEnable( FilesLevelIdealPlayersPanel, true );

		TUpDialog::SetPanelValue( FilesLevelAuthorPanel, lvl.Author() );
		TUpDialog::SetPanelValue( FilesLevelTitlePanel, lvl.Title() );
		FilesLevelEnterTexrMemo->Lines->Text =  lvl.EnterText();
		TUpDialog::SetPanelValue( FilesLevelIdealPlayersPanel, lvl.IdealPlayers() );
    }
    catch	( ... ) {
		TUpDialog::SetControlEnable( FilesLevelAuthorPanel, false );
		TUpDialog::SetControlEnable( FilesLevelTitlePanel, false );
		FilesLevelEnterTexrMemo->Lines->Text = "";
		TUpDialog::SetControlEnable( FilesLevelIdealPlayersPanel, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesHex(TObject *Sender)
{
    CUpInput	myinput;
    bool		myEnable;
    int			linenow;

    myinput 	= TUpDialog::GetInputItem();
    myEnable	= myinput.FileType().PaneHexdump();

    FilesHexDumpTrackBar->Enabled       = myEnable;
	if	( ! myEnable )	FilesHexMemo->Lines->Text = "";

    if	( ! myEnable )	return;

    struct stat	mystat;
    if	( ::stat( myinput.File().PathName(), &mystat ) != 0 )	return;

	// Should we reset the thing ? (file changed)
    if	( itsDumpSize != (dword_t)mystat.st_size ) {
		itsUpdateFlag++;
    	itsDumpOffset 	= 0;
        itsDumpSize		= mystat.st_size;

        FilesHexDumpTrackBar->Min		= 0;
        FilesHexDumpTrackBar->Max		= itsDumpSize / 512;
        FilesHexDumpTrackBar->Position	= 0;
		FilesHexDumpTrackBar->LineSize	= 1;
        FilesHexDumpTrackBar->PageSize	= 128;
		itsUpdateFlag--;
    }

    // Get data from the file
    FILE *	strm;
    strm = ::fopen( myinput.File().PathName(), "rb" );
    if	( ! strm )	return;

	char	databuffer[512];
	char	dumpline[512];
    dword_t	readsize;
    dword_t	off;
    dword_t	pos;

    ::fseek( strm, itsDumpOffset, SEEK_SET );
    readsize = ::fread( databuffer, 1, 512, strm );
    ::fclose( strm );

	// Dump the lines

    for	( off = 0, linenow = 0; off < readsize; off = off + 16, linenow++ ) {
		::sprintf( dumpline, "%08X : ", itsDumpOffset + off );

		for	( pos = 0; (pos < 16) && (off+pos < readsize); pos++ ) {
        	::sprintf( dumpline + ::strlen( dumpline ), "%02X ", databuffer[off + pos] & 0xFF );
        }

        while	( pos < 16 ) {
			::strcat( dumpline, "-- " );
            pos++;
        }

		::strcat( dumpline, " - " );

		for	( pos = 0; (pos < 16) && (off+pos < readsize); pos++ ) {
        	if	( ( databuffer[off + pos] < 0 ) || ( databuffer[off + pos] >= ' ' ) ) {
	        	::sprintf( dumpline + ::strlen( dumpline ), "%c", databuffer[off + pos] );
            }
            else {
            	::strcat( dumpline, "." );
            }
        }
        if	( linenow >= FilesHexMemo->Lines->Count ) {
			FilesHexMemo->Lines->Add( dumpline );
        }
        else {
			FilesHexMemo->Lines->Strings[linenow] = dumpline;
        }
    }
    while	( FilesHexMemo->Lines->Count > linenow ) {
		FilesHexMemo->Lines->Delete( linenow );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesShot(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();
    try {

	    if	( ! myinput.FileType().PaneScreenshot() )	throw	1;

		CUnFile			unf( myinput.File().PathName() );
        CUnNameTable	ntb( unf );
        CUnExportTable	etb( unf );
        CUnImportTable	itb( unf );
        CUnLevelInfo	lvl( unf, ntb, etb, itb );

        // Are there any shots available ?
		if	( lvl.ShotCount() == 0 ) throw	1;

		// Adjust
        if	( itsShotOffset >= (dword_t)lvl.ShotCount() ) itsShotOffset = lvl.ShotCount() - 1;

        FilesShotSaveBitBtn->Enabled = true;
        FilesShotPrevBitBtn->Enabled = itsShotOffset > 0;
        FilesShotNextBitBtn->Enabled = itsShotOffset + 1 < (dword_t)lvl.ShotCount();

		TUpDialog::ShowMyPicture( FilesShotScrollBox, FilesShotImage, lvl.Screenshot( (word_t)itsShotOffset ) );
    }

	catch	( ... ) {
	    FilesShotSaveBitBtn->Enabled	= false;
	    FilesShotPrevBitBtn->Enabled	= false;
	    FilesShotNextBitBtn->Enabled	= false;
		FilesShotImage->Width 	= 0;
		FilesShotImage->Height	= 0;
        itsShotOffset			= 0;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesTextures(TObject *Sender)
{
    CUpInput	myinput;
    myinput 	= TUpDialog::GetInputItem();

	try	{
	    if	( ! myinput.FileType().PaneTextures() )	throw	1;

		CUnUtils		utl( myinput.File().PathName() );

		// Get a list of textures
    	unr_actor_tl	actorlist = utl.ActorList( "Texture" );
	    if	( actorlist.size() == 0 )	throw 1;

    	TUpDialog::SetControlEnable( FilesTexturesComboBox, true );
		FilesTexturesSaveBitBtn->Enabled	= true;

	    // Update the texture combo data
	    unr_actor_tli	loop;
	    int				item;
	    loop = actorlist.begin();
	    item = 0;

	    // Update the list as long as there are items in both
		itsUpdateFlag++;
	    while	( ( item < FilesTexturesComboBox->Items->Count ) && ( loop != actorlist.end() ) ) {
    		if	( ::strcmp( FilesTexturesComboBox->Items->Strings[item].c_str(), (*loop).name ) ) {
				FilesTexturesComboBox->Items->Strings[item] = (*loop).name;
	        }
    	    loop++;
        	item++;
	    }

		// Insert to the list as long as we have additional data
    	while	( loop != actorlist.end() ) {
    		FilesTexturesComboBox->Items->Add( (*loop).name );
	        loop++;
    	    item++;
	    }

		// Remove items as long as possible
    	while	( item < FilesTexturesComboBox->Items->Count ) {
    		FilesTexturesComboBox->Items->Delete( item );
	    }
		itsUpdateFlag--;

		// Is the combo correctly positioned ?
    	if	( FilesTexturesComboBox->ItemIndex < 0 ) {
    		FilesTexturesComboBox->ItemIndex = 0;
	    }
	    if	( FilesTexturesComboBox->ItemIndex >= FilesTexturesComboBox->Items->Count ) {
    		FilesTexturesComboBox->ItemIndex = FilesTexturesComboBox->Items->Count - 1;
	    }

	    // Put the texture on display
	    unr_actor_t	myactor;
    	::strcpy( myactor.name, SELITEM( FilesTexturesComboBox ) );

	    utl.Seek( myactor );
		CUnTexture	mytexture( 	utl.UnFile(),
								utl.UnNameTable(),
								utl.UnExportTable(),
								utl.UnImportTable() );

		TUpDialog::ShowMyPicture( FilesTexturesScrollBox, FilesTexturesImage, &mytexture );
	}
    catch	( ... ) {
    	TUpDialog::SetControlEnable( FilesTexturesComboBox, false );
		FilesTexturesSaveBitBtn->Enabled	= false;
		FilesTexturesImage->Width 			= 0;
		FilesTexturesImage->Height			= 0;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesPicture(TObject *Sender)
{
    CUpInput		myinput;
    myinput 	= TUpDialog::GetInputItem();
    try	{
	    if	( ! myinput.FileType().PanePicture() )	throw 1;
        TUpDialog::ShowMyPicture(	FilesPictureScrollBox,
        							FilesPictureImage,
                                    myinput.File().PathName() );
	}
    catch	( ... ) {
    	FilesPictureImage->Width	= 0;
    	FilesPictureImage->Height	= 0;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesText(TObject *Sender)
{
    CUpInput		myinput;
    myinput = TUpDialog::GetInputItem();
    try	{
	    if	( ! myinput.FileType().PaneText() )	throw 1;
		TUpDialog::SetControlEnable( FilesTextMemo, true );
		FilesTextMemo->Lines->Clear();
        FilesTextMemo->Lines->LoadFromFile( myinput.File().PathName() );
	}
    catch	( ... ) {
		TUpDialog::SetControlEnable( FilesTextMemo, false );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesHtml(TObject *Sender)
{
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateFilesFile(TObject *Sender)
{
	bool		myEnable;
    CUpInput	myinput;

	myEnable = FilesCheckListBox->ItemIndex >= 0;
    if	( myEnable ) {
	    myinput = itsDoc.InputListItem( SELITEM( FilesCheckListBox ) );
	}
    myEnable = myinput.FileType().PaneFile();

	TUpDialog::SetControlEnable( FilesFileLocalPathPanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileFileSizePanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileCreationTimePanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileModificationTimePanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileAttributesPanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileCRC32ZipPanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileCRC32AdlerPanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileTargetPathPanel, myEnable );
	TUpDialog::SetControlEnable( FilesFileDetectedTypePanel, myEnable );

    if	( ! myEnable )	return;

    struct stat	mystat;
    if	( ::stat( myinput.File().PathName(), &mystat ) != 0 )	return;

	TUpDialog::SetPanelValue( FilesFileLocalPathPanel, myinput.File().PathName() );
	TUpDialog::SetPanelValue( FilesFileFileSizePanel, (dword_t)mystat.st_size );
	TUpDialog::SetPanelValue( FilesFileCreationTimePanel, mystat.st_ctime );
	TUpDialog::SetPanelValue( FilesFileModificationTimePanel, mystat.st_mtime );
	TUpDialog::SetPanelValue( FilesFileTargetPathPanel, myinput.FileType().TargetDir() );
	TUpDialog::SetPanelValue( FilesFileDetectedTypePanel, myinput.FileType().Name() );

	char	attribs[64];
	::strcpy( attribs, mystat.st_mode & S_IFDIR	 ? "D " : "- " );
	::strcpy( attribs, mystat.st_mode & S_IFCHR	 ? "Z " : "- " );
	::strcat( attribs, mystat.st_mode & S_IFREG  ? "F " : "- " );
	::strcat( attribs, mystat.st_mode & S_IWRITE ? "W " : "- " );
	::strcat( attribs, mystat.st_mode & S_IREAD	 ? "R " : "- " );
	::strcat( attribs, mystat.st_mode & S_IEXEC	 ? "X " : "- " );
   	TUpDialog::SetPanelValue( FilesFileAttributesPanel, attribs );

    // Calculate CRC32 and CRC32 Adler
	char *	calcbuf;
    dword_t	calclen;
    FILE *	strm;
    CCrc32	mycrc;
    dword_t	adler;

    strm = ::fopen( myinput.File().PathName(), "rb" );
    if	( ! strm )	return;

    calcbuf = new char[8192];

    adler = 0;
	while	( ! feof( strm ) ) {
		calclen = ::fread( calcbuf, 1, 8192, strm );
        adler = ::adler32( adler, calcbuf, calclen );
        mycrc.Calculate( calcbuf, calclen );
    }
    ::fclose( strm );
	TUpDialog::SetPanelValueHex( FilesFileCRC32ZipPanel, mycrc.Crc32() );
	TUpDialog::SetPanelValueHex( FilesFileCRC32AdlerPanel, adler );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesCheckListBoxClickCheck(TObject *Sender)
{
	TUpDialog::ChkClkCheckBoxList( FilesCheckListBox, (void *)(&(itsDoc.InputList())) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesAddBitBtnClick(TObject *Sender)
{
	Application->CreateForm( __classid(TUpAddFilesDialog), &UpAddFilesDialog );
    UpAddFilesDialog->itsDoc = &itsDoc;
	UpAddFilesDialog->ShowModal();
    UpAddFilesDialog->Release();
	UpAddFilesDialog = NULL;

    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesDeleteBitBtnClick(TObject *Sender)
{
	if	( FilesCheckListBox->ItemIndex < 0 )	return;
    itsDoc.InputListDelete( SELITEM( FilesCheckListBox ) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesHexDumpTrackBarChange(TObject *Sender)
{
	if	( itsUpdateFlag )	return;
    itsDumpOffset = 512 * FilesHexDumpTrackBar->Position;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesShotScrollBoxResize(TObject *Sender)
{
	TUpDialog::CenterDisplayImage( FilesShotScrollBox, FilesShotImage );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesTexturesScrollBoxResize(TObject *Sender)
{
	TUpDialog::CenterDisplayImage( FilesTexturesScrollBox, FilesTexturesImage );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesShotPrevBitBtnClick(TObject *Sender)
{
	if	( itsShotOffset > 0 )	itsShotOffset--;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesShotNextBitBtnClick(TObject *Sender)
{
	itsShotOffset++;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesPictureScrollBoxResize(TObject *Sender)
{
	TUpDialog::CenterDisplayImage( FilesPictureScrollBox, FilesPictureImage );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesTexturesSaveBitBtnClick(TObject *Sender)
{
	TUpDialog::SaveMyPicture( FilesTexturesImage );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FilesShotSaveBitBtnClick(TObject *Sender)
{
	TUpDialog::SaveMyPicture( FilesShotImage );
}

//---------------------------------------------------------------------------
// EOF TUpDialogFiles.cpp
//---------------------------------------------------------------------------
