//---------------------------------------------------------------------------
// TUpDialogMirror.cpp
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpDialog.h"
#include "TUpMirrorDialog.h"

//---------------------------------------------------------------------------
#define	SELITEM(l)		l->Items->Strings[l->ItemIndex].c_str()
#define	IDXITEM(l,i)	l->Items->Strings[i].c_str()
#define	IDXIREF(l,i)	l->Items->Strings[i]

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateMirror(TObject *Sender) {
    itsUpdateFlag++;
    TUpDialog::PopulateMirrorServer( Sender );
    TUpDialog::PopulateMirrorServerPath( Sender );
    TUpDialog::PopulateMirrorServerFiles( Sender );
    TUpDialog::PopulateMirrorLocal( Sender );
    itsUpdateFlag--;
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateMirrorServer(TObject *Sender) {
	bool	mayconn;
	bool	offline;
    bool	online;

    if	( FtpMirrorMessagePanel->Caption != itsFtp.Message() ) {
		FtpMirrorMessagePanel->Caption	= itsFtp.Message();
    }
    FtpMirrorIpEdit->Text           = itsDoc.FtpMirIp();
    FtpMirrorPortEdit->Text         = itsDoc.FtpMirPort();
    FtpMirrorLoginEdit->Text        = itsDoc.FtpMirLogin();
    FtpMirrorPassMaskEdit->Text     = itsDoc.FtpMirPassw();
    FtpMirrorAddCheckBox->Checked	= itsDoc.FtpMirAdd();
    FtpMirrorDelCheckBox->Checked   = itsDoc.FtpMirDel();
    FtpMirrorModCheckBox->Checked   = itsDoc.FtpMirMod();

    mayconn	= (itsDoc.FtpMirIp()[0] != 0) && (itsDoc.FtpMirPort() != 0);
	offline = (itsFtp.State() == ftp_state_offline);
    online	= (itsFtp.State() == ftp_state_online);

	FtpMirrorIpEdit->Enabled                = offline;
    FtpMirrorPortEdit->Enabled              = offline;
    MirrorPasvCheckBox->Enabled             = offline;
    FtpMirrorLoginEdit->Enabled             = offline;
    FtpMirrorPassMaskEdit->Enabled          = offline;
    FtpMirrorServerRootEdit->Enabled        = offline;
    FtpMirrorConnectServerBitBtn->Enabled	= offline && mayconn;
    FtpMirrorDisconnectBitBtn->Enabled      = ! offline && mayconn && (itsFtp.State() != ftp_state_logout);

    if	( FtpMirrorLocalFilesListBox->ItemIndex >= 0 ) {
    	if ( FtpMirrorLocalFilesListBox->Items->Strings[FtpMirrorLocalFilesListBox->ItemIndex].c_str()[0] != '<' ) {
			FtpMirrorSubmitButton->Enabled = online;
        }
	    else {
			FtpMirrorSubmitButton->Enabled = false;
	    }
    }
    else {
		FtpMirrorSubmitButton->Enabled = false;
    }
    FtpMirrorMirrorButton->Enabled = online;
	FtpMirrorRefreshButton->Enabled = online;
	FtpMirrorMirrorServerButton->Enabled = online;

    if	( FtpMirrorServerFilesListBox->ItemIndex >= 0 ) {
    	if ( FtpMirrorServerFilesListBox->Items->Strings[FtpMirrorServerFilesListBox->ItemIndex].c_str()[0] != '<' ) {
			FtpMirrorDownloadButton->Enabled = online;
        }
	    else {
			FtpMirrorDownloadButton->Enabled = false;
	    }
    }
    else {
		FtpMirrorDownloadButton->Enabled = false;
    }

}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateMirrorServerPath(TObject *Sender) {
	if	( itsFtp.State() == ftp_state_offline ) {
    	if	( FtpMirrorServerRootEdit->Text != itsDoc.FtpMirServerRoot() ) {
	    	FtpMirrorServerRootEdit->Text = itsDoc.FtpMirServerRoot();
        }
		return;
    }

    if	( itsFtp.State() != ftp_state_online ) {
    	return;
    }

	if	( MirrorPasvCheckBox->Checked != itsDoc.FtpMirPasv() ) {
		MirrorPasvCheckBox->Checked = itsDoc.FtpMirPasv();
    }

   	if	( FtpMirrorServerRootEdit->Text != itsFtp.Cwd() ) {
    	FtpMirrorServerRootEdit->Text = itsFtp.Cwd();
    }

	if	( itsDoUpload ) {
		itsDoUpload = false;
      	itsFtp.Cwd( itsDoc.FtpMirServerRoot() );
        return;
    }

	if	( ::strcmp( itsDoc.FtpMirServerRoot(), itsFtp.Cwd() ) ) {
       	if	( itsDoPwd ) {
    		itsDoc.FtpMirServerRoot( itsFtp.Cwd() );
            itsDoPwd = false;
        }
        else {
           	itsFtp.Cwd( itsDoc.FtpMirServerRoot() );
            itsDoPwd = true;
        }
	}
    else {
        itsDoPwd = false;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateMirrorServerFiles(TObject *Sender) {
	if	( itsFtp.State() == ftp_state_offline ) {
    	if	( FtpMirrorServerFilesListBox->Enabled == true ) {
			TUpDialog::SetControlEnable( FtpMirrorServerFilesListBox, false );
        }
		return;
    }
    if	( itsFtp.State() != ftp_state_online ) {
    	if	( FtpMirrorServerFilesListBox->Enabled == true ) {
			TUpDialog::SetControlEnable( FtpMirrorServerFilesListBox, false );
        }
    	return;
    }
	if	( itsDoRefresh ) {
		TUpDialog::SetControlEnable( FtpMirrorServerFilesListBox, true );
        FtpMirrorServerFilesListBox->Items->Clear();
		if	( FtpMirrorServerRootEdit->Text != "/" ) {
	        FtpMirrorServerFilesListBox->Items->Add( "<..>" );
        }
		for	( CFtpFile_lci loop = itsFtp.Dir().begin(); loop != itsFtp.Dir().end(); loop++ ) {
			if	( (*loop).Dirf() ) {
				char	myline	[1024];
                ::sprintf( myline, "<%s>", (*loop).Name() );
		        FtpMirrorServerFilesListBox->Items->Add( myline );
            }
            else {
		        FtpMirrorServerFilesListBox->Items->Add( (*loop).Name() );
            }
        }
        itsDoRefresh = false;
        if	( itsDoDownload ) {
        	itsDoDirectory = true;
            itsDoDownload = false;
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::PopulateMirrorLocal(TObject *Sender) {
    if	( itsDoc.FtpMirLocalRoot()[0] == 0 ) {
		if		( itsDoc.Uz2Repository()[0] != 0 ) {
        	itsDoc.FtpMirLocalRoot( itsDoc.Uz2Repository() );
        }
		else if	( itsDoc.UzRepository()[0] != 0 ) {
        	itsDoc.FtpMirLocalRoot( itsDoc.UzRepository() );
        }
		else {
	    	char	mydrive[3];
    	    mydrive[0] = (char)(::getdisk() + 'A' );
	        mydrive[1] = ':';
    	    mydrive[2] = 0;
        	itsDoc.FtpMirLocalRoot( mydrive );
        }
        FtpMirrorLocalRootEdit->Text = "";
    }

   	if	( ( FtpMirrorLocalRootEdit->Text != itsDoc.FtpMirLocalRoot() ) ||
       	  ( itsDoDirectory ) ) {
		TSearchRec	sr;
        struct stat mystat;
    	char		wild	[512];
   	  	char		myfile	[512];

        ::sprintf(	wild, "%s\\*.*", itsDoc.FtpMirLocalRoot() );

		FtpMirrorLocalFilesListBox->Items->Clear();
        ::strcpy( myfile, itsDoc.FtpMirLocalRoot() );
        if	( myfile[0] ) {
			if	( myfile[ ::strlen( myfile ) - 1 ] == '\\' ) {
               	myfile[ ::strlen( myfile ) - 1 ] = 0;
                itsDoc.FtpMirLocalRoot( myfile );
            }
        }

	    if	( FindFirst( wild, faAnyFile, sr ) == 0 ) {
			do {
				if	( sr.Name == "." )	continue;
				::sprintf( myfile, "%s\\%s", itsDoc.FtpMirLocalRoot(), sr.Name.c_str() );
				if	( ::stat( myfile, &mystat ) != 0 )	continue;
                if	( mystat.st_mode & S_IFDIR ) {
					::sprintf( myfile, "<%s>", sr.Name.c_str() );
                }
                else {
					::sprintf( myfile, "%s", sr.Name.c_str() );
                }
				FtpMirrorLocalFilesListBox->Items->Add( myfile );
            }	while ( FindNext( sr ) == 0 );
        }
		FindClose( sr );
        FtpMirrorLocalRootEdit->Text = itsDoc.FtpMirLocalRoot();
        itsDoDirectory = false;
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorIpEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirIp( FtpMirrorIpEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorPortEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirPort( (unsigned short)::atoi( FtpMirrorPortEdit->Text.c_str() ) );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorLoginEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirLogin( FtpMirrorLoginEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorPassMaskEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirPassw( FtpMirrorPassMaskEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorServerRootEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirServerRoot( FtpMirrorServerRootEdit->Text.c_str() );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorLocalRootEditChange(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirLocalRoot( FtpMirrorLocalRootEdit->Text.c_str() );
	itsDoDirectory = true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorAddCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirAdd( FtpMirrorAddCheckBox->Checked );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorDelCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirDel( FtpMirrorDelCheckBox->Checked );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorModCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirMod( FtpMirrorModCheckBox->Checked );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::MirrorPasvCheckBoxClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	itsDoc.FtpMirPasv( MirrorPasvCheckBox->Checked );
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorLocalFilesListBoxDblClick( TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( FtpMirrorLocalFilesListBox->ItemIndex < 0 )	return;
	AnsiString	mypath = FtpMirrorLocalFilesListBox->Items->Strings[FtpMirrorLocalFilesListBox->ItemIndex];
    if	( mypath.c_str()[0] == '<' ) {
    	if	( mypath == "<..>" ) {
			char	uppath[1024];
            ::strcpy( uppath, itsDoc.FtpMirLocalRoot() );
            if	( ::strrchr( uppath, '\\' ) ) {
            	* ::strrchr( uppath, '\\' ) = 0;
            }
            mypath = uppath;
        }
        else {
			mypath.Delete( 1, 1 );
    	    mypath.Delete( mypath.Length(), 1 );
			mypath = FtpMirrorLocalRootEdit->Text + "\\" + mypath;
        }

		itsUpdateFlag++;
        FtpMirrorLocalRootEdit->Text = mypath;
        itsDoc.FtpMirLocalRoot( FtpMirrorLocalRootEdit->Text.c_str() );
		itsUpdateFlag--;
		itsDoDirectory = true;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorServerFilesListBoxDblClick( TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( FtpMirrorServerFilesListBox->ItemIndex < 0 )	return;
	AnsiString	mypath = FtpMirrorServerFilesListBox->Items->Strings[FtpMirrorServerFilesListBox->ItemIndex];
    if	( mypath.c_str()[0] == '<' ) {
    	if	( mypath == "<..>" ) {
			char	uppath[1024];
            ::strcpy( uppath, itsDoc.FtpMirServerRoot() );
            if	( ::strrchr( uppath, '/' ) ) {
            	* ::strrchr( uppath, '/' ) = 0;
            }
            if	( *uppath )	mypath = uppath;
            else			mypath = "/";
        }
        else {
			mypath.Delete( 1, 1 );
    	    mypath.Delete( mypath.Length(), 1 );
            if	( FtpMirrorServerRootEdit->Text == "/" ) {
				mypath = "/" + mypath;
            }
            else {
				mypath = FtpMirrorServerRootEdit->Text + "/" + mypath;
            }
        }

		itsUpdateFlag++;
        itsDoc.FtpMirServerRoot( mypath.c_str() );
        itsDoRefresh = true;
		itsUpdateFlag--;
	    TUpDialog::Populate( Sender );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorConnectServerBitBtnClick(TObject *Sender) {
	itsFtp.Pasv( itsDoc.FtpMirPasv() );
	itsFtp.Login(	itsDoc.FtpMirIp(),
                    itsDoc.FtpMirPort(),
                    itsDoc.FtpMirLogin(),
                    itsDoc.FtpMirPassw() );
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorDisconnectBitBtnClick(TObject *Sender) {
	itsFtp.Logout();
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorSubmitButtonClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( FtpMirrorLocalFilesListBox->ItemIndex < 0 )	return;
	AnsiString	mypath = itsDoc.FtpMirLocalRoot();

    mypath = mypath + "\\";
    mypath = mypath + FtpMirrorLocalFilesListBox->Items->Strings[FtpMirrorLocalFilesListBox->ItemIndex];
    itsFtp.Upload( mypath.c_str() );
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    itsDoUpload		= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorRefreshButtonClick(TObject *Sender) {
	itsFtp.Cwd( itsDoc.FtpMirServerRoot() );
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorDownloadButtonClick(TObject *Sender) {
	if	( itsUpdateFlag )	return;
	if	( FtpMirrorServerFilesListBox->ItemIndex < 0 )	return;
	AnsiString	mypath = itsDoc.FtpMirLocalRoot();

    mypath = mypath + "\\";
    mypath = mypath + FtpMirrorServerFilesListBox->Items->Strings[FtpMirrorServerFilesListBox->ItemIndex];
    itsFtp.Download( mypath.c_str() );
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    itsDoDownload	= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorRefreshLocalButtonClick(TObject *Sender) {
    itsDoDirectory	= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorMirrorServerButtonClick(TObject *Sender) {
   	Application->CreateForm( __classid(TUpMirrorDialog), &UpMirrorDialog );
    UpMirrorDialog->FtpList = TUpDialog::CreateMirrorList( itsFtp.Dir(), TUpDialog::LocalMirrorFileList(), true );
	::strcpy( UpMirrorDialog->LocalDirectory, itsDoc.FtpMirLocalRoot() );
    UpMirrorDialog->FtpClient = &itsFtp;
    UpMirrorDialog->ShowModal();
	Application->OnIdle = MyIdleHandler;
	UpMirrorDialog->Release();
	UpMirrorDialog = NULL;
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    itsDoDownload	= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
void __fastcall TUpDialog::FtpMirrorMirrorButtonClick(TObject *Sender) {
   	Application->CreateForm( __classid(TUpMirrorDialog), &UpMirrorDialog );
    UpMirrorDialog->FtpList = TUpDialog::CreateMirrorList( TUpDialog::LocalMirrorFileList(), itsFtp.Dir(), false );
	::strcpy( UpMirrorDialog->LocalDirectory, itsDoc.FtpMirLocalRoot() );
    UpMirrorDialog->FtpClient = &itsFtp;
	UpMirrorDialog->ShowModal();
	Application->OnIdle = MyIdleHandler;
	UpMirrorDialog->Release();
	UpMirrorDialog = NULL;
	itsDoPwd 		= false;
    itsDoRefresh	= true;
    itsDoUpload		= true;
    TUpDialog::Populate( Sender );
}

//---------------------------------------------------------------------------
// EOF: TUpDialogArchiveZip.cpp
//---------------------------------------------------------------------------
