//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TUpZipProgressDialog.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TUpZipProgressDialog *UpZipProgressDialog = NULL;

//---------------------------------------------------------------------------
// local:	Formatting of numbers
//---------------------------------------------------------------------------
static char *	MySizeFormat( char * aB, dword_t aV ) {
	if		( aV < 1000 )		::sprintf( aB, "%d", aV );
	else if	( aV < 1000000 )	::sprintf( aB, "%d.%dK", aV / 1000, (aV % 1000)/100 );
	else			   			::sprintf( aB, "%d.%dM", aV / 1000000, (aV % 1000000)/100000 );
	return	aB;
}

//---------------------------------------------------------------------------
__fastcall TUpZipProgressDialog::TUpZipProgressDialog(TComponent* Owner)
	: TForm(Owner)
{
	itsDoc = NULL;
	Application->OnIdle = MyIdleHandler;
}

//---------------------------------------------------------------------------
void __fastcall TUpZipProgressDialog::MyIdleHandler(TObject *Sender, bool &Done ) {
	Done = false;

	if		( itsDoc->ZipProgress().Aborting() ) {
        ModalResult = mrCancel;
    }
    else if	( itsDoc->ZipProgress().Ready() ) {
        ModalResult = mrOk;
    }
    else {
		char	numbuf[32];
		TaskPanel->Caption			= itsDoc->ZipProgress().Task();
        FileNamePanel->Caption		= itsDoc->ZipProgress().FileName();
        TotalFilesPanel->Caption    = MySizeFormat( numbuf, itsDoc->ZipProgress().TotalFiles() );
        FilesDonePanel->Caption     = MySizeFormat( numbuf, itsDoc->ZipProgress().FilesDone() );
        FileBytesPanel->Caption     = MySizeFormat( numbuf, itsDoc->ZipProgress().FileBytes() );
        FileBytesDonePanel->Caption = MySizeFormat( numbuf, itsDoc->ZipProgress().FileBytesDone() );
        TotalBytesPanel->Caption    = MySizeFormat( numbuf, itsDoc->ZipProgress().TotalBytes() );
        TotalBytesDonePanel->Caption= MySizeFormat( numbuf, itsDoc->ZipProgress().TotalBytesDone() );
        ProgressBar->Min            = 0;
        ProgressBar->Max            = itsDoc->ZipProgress().TotalBytes() / 1024;
        ProgressBar->Position		= itsDoc->ZipProgress().TotalBytesDone() / 1024;
        ProgressBar->Step			= 1;
		SLEEP( 100 );
    }
}

//---------------------------------------------------------------------------
void __fastcall TUpZipProgressDialog::CancelButtonClick(TObject *Sender)
{	// Abort the process
	itsDoc->ZipProgress().Aborting( true );
}

//---------------------------------------------------------------------------

