// --------------------------------------------------------------------
// CUtxFile.h
// Whatis:  File details
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CUtxFile_h
#define CUtxFile_h

#include	"Platform.hxx"
#include	"CDxt.hxx"

// --------------------------------------------------------------------
class CUtxFile {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CUtxFile	();
	~CUtxFile	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CUtxFile				( const CUtxFile & );
	CUtxFile & operator =	( const CUtxFile & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
    void			Propagate	( const CUtxFile & );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    int				TextureType	( void ) const;
    bool			MipMaps		( void ) const;
    bool			Masked		( void ) const;
    bool			Alpha		( void ) const;
    const char *	Group		( void ) const;
    const char *	Name		( void ) const;
	bool			Directory	( void ) const;
    const char *	File		( void ) const;
    bool			Select		( void ) const;
    CDxt &			Dxt			( void );
    const CDxt &	DxtC		( void ) const;

	// ----------------------------------------------------------------
    void			TextureType	( int );
    void			MipMaps		( bool );
    void			Masked		( bool );
    void			Alpha		( bool );
    void			Group		( const char * );
    void			Name		( const char * );
	void			Directory	( bool );
    void			File		( const char * );
    void			Select		( bool );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void			Free		( void );
    void			Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    int			itsTextureType;
    bool		itsMipMaps;
    bool		itsMasked;
    bool		itsAlpha;
    char *		itsGroup;
    char *		itsName;
	bool		itsDirectory;
    char *		itsFile;
    bool		itsSelect;
    CDxt		itsDxt;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CUtxFile>		CUtxFile_l;
typedef CUtxFile_l::iterator       	CUtxFile_li;
typedef CUtxFile_l::const_iterator	CUtxFile_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CUtxFile.h
// --------------------------------------------------------------------
