// --------------------------------------------------------------------
// CCgiArgs.hxx
// Whatis:  Utility class to read in the CGI arguments
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CCgiArgs_hxx
#define CCgiArgs_hxx
#include    "Platform.hxx"

// --------------------------------------------------------------------
// Arguments supplied by the environment (Apache server)
// --------------------------------------------------------------------
#define CGI_SERVER_SOFTWARE         "SERVER_SOFTWARE"
#define CGI_SERVER_NAME             "SERVER_NAME"
#define CGI_GATEWAY_INTERFACE       "GATEWAY_INTERFACE"
#define CGI_SERVER_PROTOCOL         "SERVER_PROTOCOL"
#define CGI_SERVER_PORT             "SERVER_PORT"
#define CGI_REQUEST_METHOD          "REQUEST_METHOD"
#define CGI_HTTP_ACCEPT             "HTTP_ACCEPT"
#define CGI_PATH_INFO               "PATH_INFO"
#define CGI_PATH_TRANSLATED         "PATH_TRANSLATED"
#define CGI_SCRIPT_NAME             "SCRIPT_NAME"
#define CGI_SCRIPT_FILENAME         "SCRIPT_FILENAME"
#define CGI_QUERY_STRING            "QUERY_STRING"
#define CGI_REMOTE_HOST             "REMOTE_HOST"
#define CGI_REMOTE_ADDR             "REMOTE_ADDR"
#define CGI_REMOTE_USER             "REMOTE_USER"
#define CGI_AUTH_TYPE               "AUTH_TYPE"
#define CGI_CONTENT_TYPE            "CONTENT_TYPE"
#define CGI_CONTENT_LENGTH          "CONTENT_LENGTH"
#define CGI_DOCUMENT_ROOT           "DOCUMENT_ROOT"
#define CGI_GATEWAY_INTERFACE       "GATEWAY_INTERFACE"
#define CGI_HTTP_ACCEPT_LANGUAGE    "HTTP_ACCEPT_LANGUAGE"
#define CGI_HTTP_CONNECTION         "HTTP_CONNECTION"
#define CGI_HTTP_EXTENSION          "HTTP_EXTENSION"
#define CGI_HTTP_HOST               "HTTP_HOST"
#define CGI_HTTP_IF_MODIFIED_SINCE  "HTTP_IF_MODIFIED_SINCE"
#define CGI_HTTP_UA_CPU             "HTTP_UA_CPU"
#define CGI_HTTP_UA_OS              "HTTP_UA_OS"
#define CGI_HTTP_USER_AGENT         "HTTP_USER_AGENT"
#define CGI_HTTP_COOKIE				"HTTP_COOKIE"

// --------------------------------------------------------------------
// Declaration of the CCgiArgs class
// --------------------------------------------------------------------
class   CCgiArgs {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CCgiArgs ();

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CCgiArgs();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operators are lethal
                // and therefore made private (won't compile if used)
    // ----------------------------------------------------------------
    CCgiArgs              ( const CCgiArgs & );
    CCgiArgs & operator = ( const CCgiArgs & );

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    const char *    Arg     	( const char * aArgName ) const;
    void            Arg     	( const char * aArgName, const char * aArgVal );
    void			Arg			( const char * aArgName, dword_t aArgVal );
    bool            Exist   	( const char * aArgName ) const;
	void			Send		( const char * aArgName ) const { Encode( Arg( aArgName ) ); }
	void			Encode		( const char * aString ) const;

    // ----------------------------------------------------------------
	public:		// Interface for saving/retrieving using file
    // ----------------------------------------------------------------
    dword_t			Save		( const char * aSaveDir, const char ** aArgNames );
    void			Load		( const char * aSaveDir, const char ** aArgNames, dword_t aIdnt );

    // ----------------------------------------------------------------
    private:    // Helpers
    // ----------------------------------------------------------------
	int				Decode			( int & aState, int & aBuf, char aChar, char aTerm );
	int				DecodeHex   	( int ) const;
	void            AddArg      	( const char * aArgName, const char * aArgVal );
	void			GetUrlPost		( void );
	void			GetFrmPost		( void );
	void			GetUrlLine		( void );
	void			InitBoundary	( void );
	bool			ReadPart		( 	char * aNam, dword_t aNamLen,
										char * aVal, dword_t aValLen );
	int				ReadByte		( void );
	bool			ReadLine		(	char * aBuf, dword_t aLen );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    void *          itsArgs;
    char			itsBoundary	[128];
    char			itsBoundBuf	[128];
    int				itsBoundLen;
    int				itsSkipLen;
    int				itsBuffLen;
    dword_t			itsContLen;
    dword_t			itsContOff;
};

// --------------------------------------------------------------------
// public:	Parser for CGI data
// --------------------------------------------------------------------
extern "C" {

extern	bool	cgi_parser( const CCgiArgs & aCgi, const char * aQ );

};

#endif  // #ifdef  CCgiArgs_hxx
// --------------------------------------------------------------------
// EOF: CCgiArgs.hxx
// --------------------------------------------------------------------
