// --------------------------------------------------------------------
// CFileScore.hxx
// Whatis:	Class for managing file and author scores
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#ifndef CFileScore_hxx
#define CFileScore_hxx

#include	"CTableFile.hxx"
#include	"CTableAuth.hxx"

// --------------------------------------------------------------------
// Declaration of the CFileScore class
// --------------------------------------------------------------------
class   CFileScore {

    // ----------------------------------------------------------------
    public:     // Constructor
    // ----------------------------------------------------------------
    CFileScore	( dword_t aFileIdnt );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
	~CFileScore	();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    void		Download		( void );
	void		Players			( dword_t );
	void		AuthorScore		( dword_t aAuthIdnt );
	void		FileScore		( dword_t aFileIdnt );
	void		Rate0			( dword_t aAddValue );
	void		Rate1			( dword_t aAddValue );
	void		Rate2			( dword_t aAddValue );
	dword_t		SharePart0		( dword_t aScaleValue );
	dword_t		SharePart1		( dword_t aScaleValue );
	dword_t		SharePart2		( dword_t aScaleValue );
	dword_t		AuthSharePart0	( dword_t aScaleValue );
	dword_t		AuthSharePart1	( dword_t aScaleValue );
	dword_t		AuthSharePart2	( dword_t aScaleValue );
    void		Update			( void );

	data_file_t	FileData	( void ) const	{ return itsNewFileData; }
	data_auth_t	AuthData	( void ) const	{ return itsNewAuthData; }

    // ----------------------------------------------------------------
    private:	// Helpers
    // ----------------------------------------------------------------
	void	CalcAuthScore	( void );
	dword_t	ShareScore		(	dword_t	aScaleValue,
								dword_t	aS0,
								dword_t	aS1,
								dword_t	aS2 );

    // ----------------------------------------------------------------
    private:	// Instance data
    // ----------------------------------------------------------------
	data_file_t	itsOldFileData;
	data_file_t	itsNewFileData;
	data_auth_t	itsOldAuthData;
	data_auth_t	itsNewAuthData;
};

#endif  // #ifdef  CFileScore_hxx
// --------------------------------------------------------------------
// EOF: CFileScore.hxx
// --------------------------------------------------------------------
