// --------------------------------------------------------------------
// CFurPusg.hxx
// Whatis:	Class for sending file to UTCMS
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-APR-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CFurPush_hxx
#define	CFurPush_hxx

#include	"CTcpSocket.hxx"

// --------------------------------------------------------------------
// Declaration of the protocol engine states
// --------------------------------------------------------------------
typedef	enum {
	fur_push_state_connect		= 0,	// Connecting to service
	fur_push_state_request		= 1,	// Send request to service
	fur_push_state_response		= 2,	// Wait response from service
	fur_push_state_transini		= 3,	// Initialize the transfer
	fur_push_state_transfer		= 4,	// Transfer file data
	fur_push_state_transack		= 5,	// Wait transfer ack from service
	fur_push_state_finalize		= 6,	// Send final accept
	fur_push_state_serclose		= 7,	// Wait service to close
	fur_push_state_ready		= 8,	// Transfer ready
	fur_push_state_error		= 9		// Error
}	fur_push_state_t;

// --------------------------------------------------------------------
// Declaration of the CFurPush class
// --------------------------------------------------------------------
class	CFurPush {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CFurPush	(	const char *	aFurPopAddr,		// IP address
					word_t			aFurPopPort,		// Port
					const char *	aFile );			// File to send

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CFurPush	( );

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CFurPush				( const CFurPush & );
	CFurPush & operator	=	( const CFurPush & );

	// ----------------------------------------------------------------
	public:		// The protocol engine interface
	// ----------------------------------------------------------------
	fur_push_state_t	State		( void );
	dword_t				SendStart	( void )	const;
	dword_t				SendOffset	( void )	const;
	dword_t				SendEnd		( void )	const;
	const char *		Message		( void )	const;
	const char *		Addr		( void )	const;
	word_t				Port		( void )	const;
	const char *		LocaFile	( void )	const;
	const char *		RemoFile	( void )	const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	dword_t				Checksum	( dword_t aLen )	const;
	void				SetFile		( const char * aFile );
	void				Connect		( void );
	void				Request		( void );
	void				Response	( fur_push_state_t );
	void				Transini	( void );
	void				Transfer	( void );
	void				Finalize	( void );
	void				Serclose	( void );
	void				Free		( void );
	void				Cleanup		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	fur_push_state_t	itsState;
	char *				itsAddr;
	word_t				itsPort;
	char *				itsLocaFile;
	char *				itsRemoFile;
	char *				itsMessage;
	dword_t				itsSendStart;
	dword_t				itsSendOffset;
	dword_t				itsSendEnd;
	CTcpSocket *		itsSock;
	struct stat			itsStat;
	FILE *				itsStream;
	time_t				itsTimeout;
	char				itsAck	[1024];
	dword_t				itsAckOffs;
};

#endif	// #ifdef  CFurPush_hxx
// --------------------------------------------------------------------
// EOF:	CFurPush.hxx
// --------------------------------------------------------------------
