// --------------------------------------------------------------------
// CIpLimit.hxx
// Whatis:	Class for detecting spam
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-APR-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CIpLimit_hxx
#define	CIpLimit_hxx

#include	"Platform.hxx"

// --------------------------------------------------------------------
// Declaration of the CIpLimit class
// --------------------------------------------------------------------
class	CIpLimit {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CIpLimit	(	const char *	aIpAddress,
					dword_t			aLimit );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CIpLimit	();


	// ----------------------------------------------------------------
	public:		// Test for access
	// ----------------------------------------------------------------
	bool		Deny		( void )	const;
	bool		Allow		( void )	const;


	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CIpLimit					( const CIpLimit & );
	CIpLimit & operator	=		( const CIpLimit & );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void		Increment		( const char * );
	void		Decrement		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsRecordNum;
	dword_t		itsLimit;
	bool		itsDenyFlag;
};

#endif	// #ifdef  CIpLimit_hxx
// --------------------------------------------------------------------
// EOF:	CIpLimit.hxx
// --------------------------------------------------------------------
