// --------------------------------------------------------------------
// CPreviewFile.hxx
// Whatis:	Class for managing sessions
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewFile_hxx
#define	CPreviewFile_hxx
#include	"CTableFile.hxx"
#include	"CTableUser.hxx"
#include	"CTableAuth.hxx"
#include	"CTablePack.hxx"
#include	"CTableType.hxx"

// --------------------------------------------------------------------
// Declaration of the CPreviewFile class
// --------------------------------------------------------------------
class	CPreviewFile {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewFile ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewFile();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewFile			  (	const CPreviewFile & );
	CPreviewFile & operator	= (	const CPreviewFile & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void					Load	( dword_t aFileIdnt, bool aCacheData = true );
	bool					Answer	( const char * aQ ) const;
	const data_file_t &		File	( void )	const	{ return itsFile; }
	const data_user_t &		User	( void )	const	{ return itsUser; }
	const data_auth_t &		Auth	( void )	const	{ return itsAuth; }
	const data_type_t &		Type	( void )	const	{ return itsType; }
	const data_pack_tl &	Pack	( void )	const	{ return itsPack; }
	const char *			BaseUrl	( void )	const	{ return itsBaseUrl; }
	const char *			FileName( void )	const	{ return itsFileName; }
	const char *			FilePath( void )	const	{ return itsFilePath; }
	dword_t					Category( void )	const	{ return itsCategory; }
	void					Pack	( const data_pack_t & aPack ) { itsPackNow = aPack; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );
	void			LoadFile	( dword_t, CMySqlConnect & );
	void			LoadUser	( CMySqlConnect & );
	void			LoadAuth	( CMySqlConnect & );
	void			LoadType	( CMySqlConnect & );
	void			LoadPack	( CMySqlConnect & );
	void			CacheFile	( bool );
	void			SetCategory	( CMySqlConnect & );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	data_file_t		itsFile;
	data_user_t		itsUser;
	data_auth_t		itsAuth;
	data_type_t		itsType;
	data_pack_tl	itsPack;
	data_pack_t		itsPackNow;
	char			itsBaseUrl	[1024];
	char			itsFileName	[1024];
	char			itsFilePath	[1024];
	char			itsPreviewer[1024];
	dword_t			itsCategory;
};

#endif	// #ifdef  CPreviewFile_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewFile.hxx
// --------------------------------------------------------------------
