// --------------------------------------------------------------------
// CPreviewLeafMenu.hxx
// Whatis:	Class for template executing
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewLeafMenu_hxx
#define	CPreviewLeafMenu_hxx

#include	"CMySqlConnect.hxx"

// --------------------------------------------------------------------
// The function is dependant on contents of the pvmeth - rule
// The following is how the characters in that rule are parsed:
// l -	levelinfo, activates:
//		LEAFMENU_SCREENSHOTS, LEAFMENU_LEVELINFO
// a -	assault briefings, activates:
//		LEAFMENU_ASSBRIEFINGS
// u -	unreal package, activates:
//		LEAFMENU_UNRDETAILS, LEAFMENU_IMPORTLIST, LEAFMENU_EXPORTLIST
// t - 	text file, activates:
//		LEAFMENU_TEXTCONTENT
// i -	image file, activates:
//		LEAFMENU_IMAGECONTENT
// r -	renderable objects, activates:
//		LEAFMENU_RENDERFRONT, LEAFMENU_RENDERLEFT, LEAFMENU_RENDERTOP, LEAFMENU_RENDERCONTENT
// x - 	textures, activates:
//		LEAFMENU_TEXTURES
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// Known leaf identifiers
// --------------------------------------------------------------------
#define	LEAFMENU_DOWNLOAD		1
#define	LEAFMENU_SIMILAR		2
#define	LEAFMENU_SCREENSHOTS	3
#define	LEAFMENU_ASSBRIEFINGS	4
#define	LEAFMENU_FILEDETAILS	5
#define	LEAFMENU_LEVELINFO		6
#define	LEAFMENU_UNRDETAILS		7
#define	LEAFMENU_IMPORTLIST		8
#define	LEAFMENU_EXPORTLIST		9
#define	LEAFMENU_TEXTCONTENT	10
#define	LEAFMENU_IMAGECONTENT	11
#define	LEAFMENU_RENDERCONTENT	12
#define	LEAFMENU_MAKEREVIEW		13
#define	LEAFMENU_TEXTURES		14
#define	LEAFMENU_RENDERFRONT	15
#define	LEAFMENU_RENDERLEFT		16
#define	LEAFMENU_RENDERTOP		17
#define	LEAFMENU_SKIN			18

#define	LEAFMENU_COUNT			19

// --------------------------------------------------------------------
// Declaration of the CPreviewLeafMenu class
// --------------------------------------------------------------------
class	CPreviewLeafMenu {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewLeafMenu ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewLeafMenu();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewLeafMenu			  (	const CPreviewLeafMenu & );
	CPreviewLeafMenu & operator	= (	const CPreviewLeafMenu & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Load		(	dword_t		aFileIdnt,
									int			aLeafIdnt );
	bool			Answer		( const char * aQ ) const;

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	bool			itsLeafUsage[LEAFMENU_COUNT];
	int				itsLeafNow;

};

#endif	// #ifdef  CPreviewLeafMenu_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewLeafMenu.hxx
// --------------------------------------------------------------------
