// --------------------------------------------------------------------
// CPreviewLevelInfo.hxx
// Whatis:	Class for previewing screenshots
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewLevelInfo_hxx
#define	CPreviewLevelInfo_hxx

#include	"CUnLevelInfo.hxx"

// --------------------------------------------------------------------
// Declaration of the CPreviewLevelInfo class
// --------------------------------------------------------------------
class	CPreviewLevelInfo {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewLevelInfo ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewLevelInfo();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewLevelInfo			  (	const CPreviewLevelInfo & );
	CPreviewLevelInfo & operator	= (	const CPreviewLevelInfo & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Load		( const char * aUnrFile );
	bool			Answer		( const char * aQ ) const;
	CUnLevelInfo *	LevelInfo	( void ) { return itsLevelInfo; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup		( void );
	void			Free		( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	CUnLevelInfo *	itsLevelInfo;
};

#endif	// #ifdef  CPreviewLevelInfo_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewLevelInfo.hxx
// --------------------------------------------------------------------
