// --------------------------------------------------------------------
// CPreviewSkin.hxx
// Whatis:	Class for previewing UT2003 skins
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CPreviewSkin_hxx
#define	CPreviewSkin_hxx

#include	"CTableFile.hxx"

// --------------------------------------------------------------------
// Maximum number of skins in one UPL file
// --------------------------------------------------------------------
#define	MAX_SKIN_COUNT	16

// --------------------------------------------------------------------
// Declaration of the CPreviewSkin class
// --------------------------------------------------------------------
class	CPreviewSkin {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CPreviewSkin ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CPreviewSkin();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CPreviewSkin			  (	const CPreviewSkin & );
	CPreviewSkin & operator	= (	const CPreviewSkin & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Load		( dword_t aFileIdnt );
	bool			Answer		( const char * aQ ) const;
	dword_t			SkinCount	( void ) const { return itsSkinCount; }
	void			SetIndex	( dword_t aI ) { itsSkinIndex = aI; }

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			Cleanup			( void );
	void			Free			( void );
	void			ParseUPL		( const char * aUplFile );
	void			PreloadPortrait	( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	dword_t			itsSkinCount;
	dword_t			itsSkinIndex;
	data_file_t		itsFileData;
	char			itsPortraitUrl		[MAX_SKIN_COUNT][1024];
	char			itsDefaultName		[MAX_SKIN_COUNT][128];
	char			itsMesh				[MAX_SKIN_COUNT][128];
	char 			itsSpecies			[MAX_SKIN_COUNT][128];
	char			itsPortrait			[MAX_SKIN_COUNT][128];
	char			itsText				[MAX_SKIN_COUNT][128];
	char			itsSex				[MAX_SKIN_COUNT][128];
	char			itsBodySkin			[MAX_SKIN_COUNT][128];
	char			itsFaceSkin			[MAX_SKIN_COUNT][128];
	char			itsMenu				[MAX_SKIN_COUNT][128];
	char			itsAggressiveness	[MAX_SKIN_COUNT][128];
	char			itsCombatStyle		[MAX_SKIN_COUNT][128];
	char			itsFavoriteWeapon	[MAX_SKIN_COUNT][128];
	char			itsTactics			[MAX_SKIN_COUNT][128];
	char			itsStrafingAbility	[MAX_SKIN_COUNT][128];
	char			itsAccuracy			[MAX_SKIN_COUNT][128];


};

#endif	// #ifdef  CPreviewSkin_hxx
// --------------------------------------------------------------------
// EOF:	CPreviewSkin.hxx
// --------------------------------------------------------------------
