// --------------------------------------------------------------------
// CScore.hxx
// Whatis:	Class for calculating scores
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CScore_hxx
#define	CScore_hxx
#include	"CTableAuth.hxx"
#include	"CTableFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CScore class
// --------------------------------------------------------------------
class	CScore {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CScore ( const data_file_t & );
	CScore ( const data_auth_t & );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CScore();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CScore			  		( const CScore & );
	CScore & operator	=	( const CScore & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	dword_t		Bad	( void ) const	{ return itsBadScore; }
	dword_t		Avg	( void ) const	{ return itsAvgScore; }
	dword_t		God	( void ) const	{ return itsGodScore; }
	dword_t		Sum	( void ) const	{ return itsSumScore; }
                                             
	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	void		Calculate	( dword_t, dword_t, dword_t );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	dword_t		itsBadScore;
	dword_t		itsAvgScore;
	dword_t		itsGodScore;
	dword_t		itsSumScore;
};

#endif	// #ifdef  CScore_hxx
// --------------------------------------------------------------------
// EOF:	CScore.hxx
// --------------------------------------------------------------------
