// --------------------------------------------------------------------
// CSession.hxx
// Whatis:	Class for managing sessions
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	14-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CSession_hxx
#define	CSession_hxx
#include	"CTableUser.hxx"
#include	"CCgiArgs.hxx"

// --------------------------------------------------------------------
// Declaration of the CSession class
// --------------------------------------------------------------------
class	CSession {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CSession ( const CCgiArgs & aCgi );

	// ----------------------------------------------------------------
	CSession (	CCgiArgs & 			aCgi,
				const char *		aLoginTemplate,
				const char *		aForwardAddress,
				const char *		aSaveDir,
				const char **		aArgNames );

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CSession() {}

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CSession			  (	const CSession & );
	CSession & operator	= (	const CSession & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	dword_t		SessId	( void ) const { return itsSessId; }
	dword_t		User	( void ) const { return itsUser.user_idnt; }
	bool		Check	( void ) const { return itsChecked; }
	void		Logout		( const CCgiArgs & );
	bool		HasCookie	( const CCgiArgs & );
	dword_t		Flag	( void ) const { return itsUser.user_flag; }
	data_user_t	UserData( void ) const { return itsUser; }
	bool		Logged	( void ) const { return itsLogged; }
	bool		CreateCookie	( CMySqlConnect &, const CCgiArgs & );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	bool		CheckCookie		( const CCgiArgs & aCgi, CMySqlConnect & );
	bool		CheckLogIn		( const CCgiArgs & aCgi, CMySqlConnect & );
	void		CheckSess		( const CCgiArgs & aCgi, CMySqlConnect & );
	void		CreateSession	( CMySqlConnect &, const CCgiArgs & );
	bool		IsBanned		( void ) const;
	void		Cleanup			( void );

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	char			itsCookieName	[256];
	char			itsCookiePath	[256];
	char			itsCookieInfo	[256];
	dword_t			itsSessId;
	bool			itsChecked;
	bool			itsLogged;
	data_user_t		itsUser;
};

#endif	// #ifdef  CSession_hxx
// --------------------------------------------------------------------
// EOF:	CSession.hxx
// --------------------------------------------------------------------
