// --------------------------------------------------------------------
// CStorage.hxx
// Whatis:	Class for accessing	the	file storage system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#ifndef	CStorage_hxx
#define	CStorage_hxx
#include	"CTableFile.hxx"

// --------------------------------------------------------------------
// Declaration of the CStorage class
// --------------------------------------------------------------------
class	CStorage {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CStorage ();

	// ----------------------------------------------------------------
	public:		// Destructor
	// ----------------------------------------------------------------
	~CStorage();

	// ----------------------------------------------------------------
	private:	// Copy	constructor	and	assignment operators are lethal
				// and therefore made private (won't compile if	used)
	// ----------------------------------------------------------------
	CStorage			  (	const CStorage & );
	CStorage & operator	= (	const CStorage & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	data_file_t		Save	(	const char *	aStorName,
								dword_t			aFlags,
								const char *	aDataFile );

	data_file_t		Load	(	const char *	aDataFile,
								dword_t			aFileIdnt );

	data_file_tl	Find	(	const char *	aStorName,
								const char *	aStorSuff );

	void			Delete	(	dword_t			aFileIdnt );

	void			Delete	(	dword_t			aFileIdnt,
								dword_t			aPackIdnt );

	data_file_t		Rename	(	dword_t			aFileIdnt,
								const char *	aStorName,
								const char *	aStorSuff );

	void			Flags	(	dword_t			aFileIdnt,
								dword_t			aFlags	);

	dword_t			Flags	(	dword_t			aFileIdnt );

	// ----------------------------------------------------------------
	private:	// Helpers
	// ----------------------------------------------------------------
	void			FileInfo(	data_file_t	&	aRecord,
								const char *	aFileName );

	void			CheckSum(	data_file_t	&	aRecord,
								const char *	aFileName );

	void			DwordSum(	char *			aCsum,
								dword_t			aSum );

	void			WordSum	(	char *			aCsum,
								word_t			aSum );

	void			ByteSum	(	char *			aCsum,
								byte_t			aSum );

	void			NibbSum	(	char *			aCsum,
								byte_t			aSum );

	void			SaveParm(	data_file_t &	aRecord );

	dword_t			Pack	(	const char *	aGzFile,
								const char *	aDataFile );

	void			UnPack	(	const char *	aDataFile,
								const char *	aGzFile	);

	// ----------------------------------------------------------------
	private:	// Instance	data
	// ----------------------------------------------------------------
	CMySqlConnect *	itsDb;
};

#endif	// #ifdef  CStorage_hxx
// --------------------------------------------------------------------
// EOF:	CStorage.hxx
// --------------------------------------------------------------------
