// --------------------------------------------------------------------
// CCache.cxx
// Whatis:	Class for caching files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUN-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CCache.hxx"
#include    "CTableCach.hxx"
#include    "CTablePref.hxx"
#include    "CMySqlWhere.hxx"

// --------------------------------------------------------------------
// public:	Constructor
// --------------------------------------------------------------------
CCache::CCache ( const char * aCacheName ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CMySqlWhere		w;
	CTablePref		pref;
	data_pref_tl	list;

	// ----------------------------------------------------------------
	// Get settings for this cache
	// ----------------------------------------------------------------
	w << "pref_name='" << aCacheName << "-cache-maxfiles'";
	list = pref.Select( db, w );
	if	( list.size() < 1 )	throw CError( "Missing preference: ", w.Where() );
	itsMaxFiles	= ::atol( (*(list.begin())).pref_valu );

	w = "";
	w << "pref_name='" << aCacheName << "-cache-maxsize'";
	list = pref.Select( db, w );
	if	( list.size() < 1 )	throw CError( "Missing preference: ", w.Where() );
	itsMaxSize	= ::atol( (*(list.begin())).pref_valu );

	w = "";
	w << "pref_name='" << aCacheName << "-cache-urlbase'";
	list = pref.Select( db, w );
	if	( list.size() < 1 )	throw CError( "Missing preference: ", w.Where() );
	::strcpy( itsUrlBase, (*(list.begin())).pref_valu );

	w = "";
	w << "pref_name='" << aCacheName << "-cache-dirbase'";
	list = pref.Select( db, w );
	if	( list.size() < 1 )	throw CError( "Missing preference: ", w.Where() );
	::strcpy( itsDirBase, (*(list.begin())).pref_valu );
}

// --------------------------------------------------------------------
// public:	Check if a file needs to be created/updated in the cache
// --------------------------------------------------------------------
bool	CCache::Exist( const char * aFileName ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CMySqlWhere		w;
	CMySqlQuote		q;
	CTableCach		cach;
	data_cach_tl	list;
	data_cach_t		data;
	struct	stat	mystat;

	// ----------------------------------------------------------------
	// Does the file exist ?
	// ----------------------------------------------------------------
	if	( ::stat( aFileName, &mystat ) )	return false;

	// ----------------------------------------------------------------
	// Is it in the cache ?
	// ----------------------------------------------------------------
	w << "cach_file='" << q.Quote( aFileName ) << "'";
	list = cach.Select( db, w );

	// ----------------------------------------------------------------
	// Not in the cache
	// ----------------------------------------------------------------
	if	( list.size() < 1 )	return false;

	// ----------------------------------------------------------------
	// Update the access time so it'll stay there for some while
	// ----------------------------------------------------------------
	data = *(list.begin());
	data.cach_ltim = ::time( NULL );
	cach.Update( db, &data );


	// ----------------------------------------------------------------
	// Set file time as well
	// ----------------------------------------------------------------
    struct  utimbuf utb;
    utb.actime  = ::time( NULL );
    utb.modtime = ::time( NULL );
    ::utime( aFileName, &utb );

	return true;
}

// --------------------------------------------------------------------
// public:	Cache a file
// --------------------------------------------------------------------
void	CCache::Cache( const char * aFileName ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CMySqlWhere		w;
	CMySqlQuote		q;
	CTableCach		cach;
	data_cach_tl	list;
	data_cach_tli	loop;
	data_cach_t		data;
	struct	stat	mystat;
	dword_t			mysize;
	char			filepath[1024];

	// ----------------------------------------------------------------
	// Does the file exist ? (if not, remove the record)
	// ----------------------------------------------------------------
	if	( ::stat( aFileName, &mystat ) ) {
		w << "cach_file='" << q.Quote( filepath ) << "'";
		cach.Delete( db, w );
		return;
	}

	// ----------------------------------------------------------------
	// Is it in the cache ?
	// ----------------------------------------------------------------
	w << "cach_file='" << q.Quote( aFileName ) << "'";
	list = cach.Select( db, w );

	// ----------------------------------------------------------------
	// If not in the cache, we have to create a new record
	// ----------------------------------------------------------------
	if	( list.size() < 1 ) {
		::memset( &data, 0, sizeof( data ) );
		::strcpy( data.cach_file, aFileName );
		data.cach_ltim = ::time( NULL );
		data.cach_size = mystat.st_size;
		cach.Insert( db, &data );
	}
	else {
		data.cach_ltim = ::time( NULL );
		cach.Update( db, &data );
	}

	// ----------------------------------------------------------------
	// Remove files from this cache until the count is under the limit
	// ----------------------------------------------------------------
	w = "";
	w << "cach_file like '" << q.Quote( itsDirBase ) << "%'";
	while	( cach.Count( db, w ) > itsMaxFiles ) {
		w << " order by cach_ltim limit 0,1";
		list = cach.Select( db, w );
		if	( list.size() < 1 )	break;
		data = *(list.begin());
		::unlink( data.cach_file );
		cach.Delete( db, &data );

		w = "";
		w << "cach_file like '" << q.Quote( itsDirBase ) << "%'";
	}
	
	// ----------------------------------------------------------------
	// Read in all records in this cache for decide whether the size is too much
	// Delete the oldest ones that are past the limit
	// ----------------------------------------------------------------
	w = "";
	w << "cach_file like '" << q.Quote( itsDirBase ) << "%' order by cach_ltim desc";
	list = cach.Select( db, w );

	mysize = 0;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		data = *loop;
		if	( mysize > itsMaxSize ) {
			::unlink( data.cach_file );
			cach.Delete( db, &data );
		}
		else {
			mysize = mysize + data.cach_size;
		}
	}	

	// ----------------------------------------------------------------
	// Set file time as well
	// ----------------------------------------------------------------
    struct  utimbuf utb;
    utb.actime  = ::time( NULL );
    utb.modtime = ::time( NULL );
    ::utime( aFileName, &utb );

}

// --------------------------------------------------------------------
// public:	Create a file name
// --------------------------------------------------------------------
char *	CCache::MakeDirname(	char *			aBuffer,
								const char *	aBaseName ) {
	::strcpy( aBuffer, itsDirBase );
	::strcat( aBuffer, "/" );
	::strcat( aBuffer, aBaseName );
	return	aBuffer;
}

// --------------------------------------------------------------------
// EOF:	CCache.cxx
// --------------------------------------------------------------------
