// --------------------------------------------------------------------
// CFileScore.cxx
// Whatis:	Download manager
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CFileScore.hxx"
#include	"CMySqlWhere.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CFileScore::CFileScore	( dword_t aFileIdnt ) {

	::memset( &itsOldFileData, 0, sizeof( itsOldFileData ) );
	::memset( &itsOldAuthData, 0, sizeof( itsOldAuthData ) );
	::memset( &itsNewFileData, 0, sizeof( itsNewFileData ) );
	::memset( &itsNewAuthData, 0, sizeof( itsNewAuthData ) );

	// Caller might just want to set the author scores !
	if	( aFileIdnt > 0 ) {
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CTableFile		file;
		CTableAuth		auth;
		CMySqlWhere		w;
		data_file_tl	flist;
		data_auth_tl	alist;

		// Current file data
		w << "file_idnt=" << aFileIdnt;
		flist = file.Select( db, w );
		if	( flist.size() == 0 )	throw CError( "Unable to find a file record" );
	
		itsOldFileData = *(flist.begin());
		itsNewFileData = itsOldFileData;
	
		// If the file has an author we will pick this along as well
		if	( itsOldFileData.file_auth > 0 ) {
			w = "";
			w << "auth_idnt=" << itsOldFileData.file_auth;
			alist = auth.Select( db, w );
			if	( alist.size() == 0 )	throw CError( "Unable to locate author" );
			itsOldAuthData = *(alist.begin());
			itsNewAuthData = itsOldAuthData;
		}
		CFileScore::CalcAuthScore();
	}
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CFileScore::~CFileScore	( ) {
}

// --------------------------------------------------------------------
// public:		Perform Download special
// --------------------------------------------------------------------
void	CFileScore::Download	( void ) {
	itsNewFileData.file_dlct++;
	itsNewFileData.file_rat2++;
	itsNewFileData.file_rate	= (dword_t)100000
								+ CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat1 )
								- CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat1 );
	CFileScore::CalcAuthScore();
}

// --------------------------------------------------------------------
// public:		Perform Download special
// --------------------------------------------------------------------
void	CFileScore::Players		( dword_t aPlayers ) {
	itsNewFileData.file_plct = itsNewFileData.file_plct + aPlayers;
	itsNewAuthData.auth_plct = itsNewAuthData.auth_plct + aPlayers;
}

// --------------------------------------------------------------------
// public:		Perform Author special
// --------------------------------------------------------------------
void	CFileScore::AuthorScore	( dword_t aAuthIdnt ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CTableAuth		auth;
	CMySqlWhere		w;
	data_auth_tl	alist;

	w = "";
	w << "auth_idnt=" << aAuthIdnt;
	alist = auth.Select( db, w );
	if	( alist.size() == 0 )	throw CError( "Unable to locate author" );
	itsOldAuthData = *(alist.begin());
	itsNewAuthData = itsOldAuthData;

	CFileScore::CalcAuthScore();
}

// --------------------------------------------------------------------
// public:		Perform FileScore special
// --------------------------------------------------------------------
void	CFileScore::FileScore	( dword_t aFileIdnt ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	CTableFile		file;
	CMySqlWhere		w;
	data_file_tl	flist;

	w = "";
	w << "file_idnt=" << aFileIdnt;
	flist = file.Select( db, w );
	if	( flist.size() == 0 )	throw CError( "Unable to locate file" );
	itsOldFileData = *(flist.begin());
	itsNewFileData = itsOldFileData;

	itsNewFileData.file_rate	= (dword_t)100000
								+ CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat1 )
								- CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat1 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
void	CFileScore::Rate0		( dword_t aAddValue ) {
	itsNewFileData.file_rat0 = itsNewFileData.file_rat0 + aAddValue;
	itsNewFileData.file_rate	= (dword_t)100000
								+ CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat1 )
								- CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat1 );
	CFileScore::CalcAuthScore();
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
void	CFileScore::Rate1		( dword_t aAddValue ) {
	itsNewFileData.file_rat1 = itsNewFileData.file_rat1 + aAddValue;
	itsNewFileData.file_rate	= (dword_t)100000
								+ CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat1 )
								- CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat1 );
	CFileScore::CalcAuthScore();
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
void	CFileScore::Rate2		( dword_t aAddValue ) {
	itsNewFileData.file_rat2 = itsNewFileData.file_rat2 + aAddValue;
	itsNewFileData.file_rate	= (dword_t)100000
								+ CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat1 )
								- CFileScore::ShareScore(	(dword_t)100000,
															itsNewFileData.file_rat0,
															itsNewFileData.file_rat2,
															itsNewFileData.file_rat1 );
	CFileScore::CalcAuthScore();
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::SharePart0	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewFileData.file_rat0,
									itsNewFileData.file_rat1,
									itsNewFileData.file_rat2 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::SharePart1	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewFileData.file_rat1,
									itsNewFileData.file_rat0,
									itsNewFileData.file_rat2 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::SharePart2	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewFileData.file_rat2,
									itsNewFileData.file_rat1,
									itsNewFileData.file_rat0 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::AuthSharePart0	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewAuthData.auth_rat0,
									itsNewAuthData.auth_rat1,
									itsNewAuthData.auth_rat2 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::AuthSharePart1	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewAuthData.auth_rat1,
									itsNewAuthData.auth_rat0,
									itsNewAuthData.auth_rat2 );
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
dword_t	CFileScore::AuthSharePart2	( dword_t aScaleValue ) {
	return	CFileScore::ShareScore(	aScaleValue,
									itsNewAuthData.auth_rat2,
									itsNewAuthData.auth_rat1,
									itsNewAuthData.auth_rat0 );
}

// --------------------------------------------------------------------
// private:		Calculate author score for new entry
// --------------------------------------------------------------------
void	CFileScore::CalcAuthScore	( void ) {
	if	( itsNewAuthData.auth_idnt > 0 ) {
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CTableFile		file;
		CMySqlWhere		w;
		data_file_tl	flist;
		data_file_tli	floop;

		w << "file_auth=" << itsNewAuthData.auth_idnt;
		flist = file.Select( db, w );

		itsNewAuthData.auth_rat0 = 0;
		itsNewAuthData.auth_rat1 = 0;
		itsNewAuthData.auth_rat2 = 0;
		itsNewAuthData.auth_dlct = 0;
		itsNewAuthData.auth_plct = 0;

		for	( floop = flist.begin(); floop != flist.end(); floop++ ) {
			itsNewAuthData.auth_rat0 = itsNewAuthData.auth_rat0 + (*floop).file_rat0;
			itsNewAuthData.auth_rat1 = itsNewAuthData.auth_rat1 + (*floop).file_rat1;
			itsNewAuthData.auth_rat2 = itsNewAuthData.auth_rat2 + (*floop).file_rat2;
			itsNewAuthData.auth_dlct = itsNewAuthData.auth_dlct + (*floop).file_dlct;
			itsNewAuthData.auth_plct = itsNewAuthData.auth_plct + (*floop).file_plct;
		}

		itsNewAuthData.auth_rate	= (dword_t)100000
									+ CFileScore::ShareScore(	(dword_t)100000,
																itsNewAuthData.auth_rat2,
																itsNewAuthData.auth_rat0,
																itsNewAuthData.auth_rat1 )
									- CFileScore::ShareScore(	(dword_t)100000,
																itsNewAuthData.auth_rat0,
																itsNewAuthData.auth_rat2,
																itsNewAuthData.auth_rat1 );
	}
}

// --------------------------------------------------------------------
// private:		Calculate shared score (ranged)
// --------------------------------------------------------------------
dword_t	CFileScore::ShareScore		(	dword_t	aScaleValue,
										dword_t	aS0,
										dword_t	aS1,
										dword_t	aS2 ) {
	double	totalcount	= aS0 + aS1 + aS2 + 1.0;
	double	sharepart	= ((double)aS0 / totalcount) * (double)aScaleValue;

	if	( sharepart < 0.0 )					sharepart = 0.0;
	if	( sharepart > (double)aScaleValue )	sharepart = (double)aScaleValue;

	return	(dword_t)sharepart;
}

// --------------------------------------------------------------------
// public:		
// --------------------------------------------------------------------
void	CFileScore::Update		( void ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );

	if	( itsNewFileData.file_idnt > 0 ) {
		if	( ( itsNewFileData.file_plct != itsOldFileData.file_plct ) ||
			  ( itsNewFileData.file_rat0 != itsOldFileData.file_rat0 ) ||
			  ( itsNewFileData.file_rat1 != itsOldFileData.file_rat1 ) ||
			  ( itsNewFileData.file_rat2 != itsOldFileData.file_rat2 ) ||
			  ( itsNewFileData.file_rate != itsOldFileData.file_rate ) ||
			  ( itsNewFileData.file_dlct != itsOldFileData.file_dlct ) ) {
			CTableFile	file;
			file.Update( db, &itsNewFileData );
			itsOldFileData = itsNewFileData;
		}
	}

	if	( itsNewAuthData.auth_idnt > 0 ) {
		if	( ( itsNewAuthData.auth_plct != itsOldAuthData.auth_plct ) ||
			  ( itsNewAuthData.auth_rat0 != itsOldAuthData.auth_rat0 ) ||
			  ( itsNewAuthData.auth_rat1 != itsOldAuthData.auth_rat1 ) ||
			  ( itsNewAuthData.auth_rat2 != itsOldAuthData.auth_rat2 ) ||
			  ( itsNewAuthData.auth_rate != itsOldAuthData.auth_rate ) ||
			  ( itsNewAuthData.auth_dlct != itsOldAuthData.auth_dlct ) ) {
			CTableAuth	auth;
			auth.Update( db, &itsNewAuthData );
			itsOldAuthData = itsNewAuthData;
		}
	}
}

// --------------------------------------------------------------------
// EOF:	CFileScore.cxx
// --------------------------------------------------------------------
