// --------------------------------------------------------------------
// CPreviewFile.cxx
// Whatis:	Session manipulation
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CCache.hxx"
#include	"CStorage.hxx"
#include	"CPreviewFile.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTablePackFile.hxx"
#include	"CTableRule.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewFile::CPreviewFile ( void ) {
	CPreviewFile::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewFile::~CPreviewFile ( void ) {
	CPreviewFile::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewFile::Load	( dword_t aFileIdnt, bool aCacheData ) {
	try	{
		if		( aFileIdnt == 0 ) {
			throw CError( "file_idnt not defined" );
		}
		else if	( aFileIdnt != itsFile.file_idnt ) {
			CMySqlConnect	db( "quest", "", "UTCMS" );

			CPreviewFile::Free();
			CPreviewFile::LoadFile( aFileIdnt, db );
			CPreviewFile::LoadUser( db );
			CPreviewFile::LoadAuth( db );
			CPreviewFile::LoadType( db );
			CPreviewFile::LoadPack( db );
			CPreviewFile::CacheFile( aCacheData );
			CPreviewFile::SetCategory( db );
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewFile::Answer	( const char * aQ ) const {
	CTableFile	file;
	CTableUser	user;
	CTableAuth	auth;
	CTableType	type;
	CTablePack	pack;
	if		( ::MySqlTableParser( file.Layout(), "file", (const char *)(&itsFile), aQ ) )	return true;
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&itsUser), aQ ) )	return true;
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&itsAuth), aQ ) )	return true;
	else if	( ::MySqlTableParser( type.Layout(), "type", (const char *)(&itsType), aQ ) )	return true;
	else if	( ::MySqlTableParser( pack.Layout(), "pack", (const char *)(&itsPackNow), aQ ) )	return true;
	else if	( ! ::strcmp( aQ, "previewer" ) ) 		{ ::printf( "%s", itsPreviewer ); return true; }
	else if	( ! ::strcmp( aQ, "category" ) ) 		{ ::printf( "%d", itsCategory ); return true; }
	else if	( ! ::strcmp( aQ, "downloadable" ) )	{ ::printf( "%s", (itsFile.file_flag & FLAG_NODOWNLOAD) == 0 ? "(DL)" : "" ); return true; }
	else if	( ! ::strcmp( aQ, "downloadable_b" ) )	{ ::printf( "%s", (itsFile.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : "<!-- " ); return true; }
	else if	( ! ::strcmp( aQ, "downloadable_e" ) )	{ ::printf( "%s", (itsFile.file_flag & FLAG_NODOWNLOAD) == 0 ? "" : " -->" ); return true; }
	else if	( ! ::strcmp( aQ, "nodownloadable_b" ) )	{ ::printf( "%s", (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : "<!-- " ); return true; }
	else if	( ! ::strcmp( aQ, "nodownloadable_e" ) )	{ ::printf( "%s", (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : " -->" ); return true; }
	else if	( ! ::strcmp( aQ, "multipack_b" ) )		{ ::printf( "%s", itsPack.size() > 1 ? "" : (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : "<!-- " ); return true; }
	else if	( ! ::strcmp( aQ, "multipack_e" ) )		{ ::printf( "%s", itsPack.size() > 1 ? "" : (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : " -->" ); return true; }
	else if	( ! ::strcmp( aQ, "singlepack_b" ) )	{ ::printf( "%s", itsPack.size() == 1 ? "" : (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : "<!-- " ); return true; }
	else if	( ! ::strcmp( aQ, "singlepack_e" ) )	{ ::printf( "%s", itsPack.size() == 1 ? "" : (itsFile.file_flag & FLAG_NODOWNLOAD) != 0 ? "" : " -->" ); return true; }
	else if	( ! ::strcmp( aQ, "imageurl" ) )	{ ::printf( "%s", itsBaseUrl ); return true; }
	else if	( ! ::strcmp( aQ, "cachefile" ) )	{ ::printf( "%s", itsFileName ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewFile::Free	( void ) {
	CPreviewFile::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewFile::Cleanup	( void ) {
	::memset( &itsFile, 0, sizeof( itsFile ) );
	::memset( &itsUser, 0, sizeof( itsUser ) );
	::memset( &itsAuth, 0, sizeof( itsAuth ) );
	::memset( &itsType, 0, sizeof( itsType ) );
	::memset( &itsPackNow, 0, sizeof( itsPackNow ) );
	itsPack.clear();
	::memset( itsBaseUrl,	0, sizeof( itsBaseUrl ) );
	::memset( itsFileName,	0, sizeof( itsFileName ) );
	::memset( itsFilePath,	0, sizeof( itsFilePath ) );
	::memset( itsPreviewer,	0, sizeof( itsPreviewer ) );
	itsCategory = 0;
}

// --------------------------------------------------------------------
// private		Load file information
// --------------------------------------------------------------------
void	CPreviewFile::LoadFile	( dword_t			aFileIdnt,
								  CMySqlConnect &	aDb ) {
	try	{
		CTableFile		tfile;
		data_file_tl	lfile;
		CMySqlWhere		w;

		w << "file_idnt=" << aFileIdnt;
		lfile = tfile.Select( aDb, w );
		if	( lfile.size() < 1 ) {
			throw CError( w.Where(), "No such file" );
		}
		itsFile = *(lfile.begin());
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::LoadFile", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::LoadFile", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Load user information
// --------------------------------------------------------------------
void	CPreviewFile::LoadUser	( CMySqlConnect & 	aDb ) {
	try	{
		CTableUser		tuser;
		data_user_tl	luser;
		CMySqlWhere		w;

		w << "user_idnt=" << itsFile.file_user;
		luser = tuser.Select( aDb, w );
		if	( luser.size() > 0 ) {
			itsUser = *(luser.begin());
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::LoadUser", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::LoadUser", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Load author information
// --------------------------------------------------------------------
void	CPreviewFile::LoadAuth	( CMySqlConnect & 	aDb ) {
	try	{
		CTableAuth		tauth;
		data_auth_tl	lauth;
		CMySqlWhere		w;

		w << "auth_idnt=" << itsFile.file_auth;
		lauth = tauth.Select( aDb, w );
		if	( lauth.size() > 0 ) {
			itsAuth = *(lauth.begin());
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::LoadAuth", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::LoadAuth", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Load type information
// --------------------------------------------------------------------
void	CPreviewFile::LoadType	( CMySqlConnect & 	aDb ) {
	try	{
		CTableType		ttype;
		CTableRule		trule;
		data_type_tl	ltype;
		data_rule_tl	lrule;
		CMySqlWhere		w;

		w << "type_idnt=" << itsFile.file_type;
		ltype = ttype.Select( aDb, w );
		if	( ltype.size() < 1 ) {
			throw CError( w.Where(), "No such type" );
		}
		itsType = *(ltype.begin());

		w = "";
		w << "rule_type=" << itsFile.file_type << " and rule_name='preview'";
		lrule = trule.Select( aDb, w );
		if	( lrule.size() > 0 ) {
			::strcpy( itsPreviewer, (*(lrule.begin())).rule_rule );
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::LoadType", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::LoadType", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Load package list
// --------------------------------------------------------------------
void	CPreviewFile::LoadPack	( CMySqlConnect & 	aDb ) {
	try	{
		CTablePack			tpack;
		CTablePackFile		tpackfile;
		data_packfile_tl	lpackfile;
		data_packfile_tli	ipackfile;
		data_pack_tl		lpack;
		CMySqlWhere			w;

		w << "packfile_file=" << itsFile.file_idnt;
		lpackfile = tpackfile.Select( aDb, w );

		for	( 	ipackfile  = lpackfile.begin();
				ipackfile != lpackfile.end();
				ipackfile++ ) {
			w = "";
			w << "pack_idnt=" << (*ipackfile).packfile_pack;
			lpack = tpack.Select( aDb, w );
			if	( lpack.size() < 1 ) {
				throw CError( w.Where(), "No such pack" );
			}
			itsPackNow = *(lpack.begin());
			itsPack.push_back( itsPackNow );
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::LoadPack", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::LoadPack", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Cache the file
// --------------------------------------------------------------------
void	CPreviewFile::CacheFile	( bool aCacheData ) {
	try	{
		CCache	mycache( "preview" );
		::sprintf( 	itsFileName, "%d-file.%s",
					itsFile.file_idnt,
					itsFile.file_suff );
		mycache.MakeDirname( itsFilePath, itsFileName );
		::strcpy( itsBaseUrl, mycache.UrlBase() );

		struct stat	mystat;
		if	( ! ::stat( itsFilePath, &mystat ) ) {
			if	( itsFile.file_mtim > mystat.st_ctime ) {
				::unlink( itsFilePath );
			}
		}

		if	( aCacheData ) {
			if	( ! mycache.Exist( itsFilePath ) ) {
				CStorage	storage;
				storage.Load( itsFilePath, itsFile.file_idnt );
				mycache.Cache( itsFilePath );
			}
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::CacheFile", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::CacheFile", "unknown" );
	}
}

// --------------------------------------------------------------------
// private		Set file category number
// --------------------------------------------------------------------
void	CPreviewFile::SetCategory	( CMySqlConnect & 	aDb ) {
	try	{
		CMySqlWhere		w;
		CTableType		type;
		data_type_t		data;
		data_type_tl	list;
		data_type_tli	loop;
		const char *	prevcat = "";
		dword_t			ctgr	= 0;

		w << "type_idnt > 0 order by type_ctgr, type_name";
		list = type.Select( aDb, w );

		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			data = *loop;
	
			// Start of a new category
			if	( ::strcmp( prevcat, data.type_ctgr ) ) {
				prevcat = (*loop).type_ctgr;
				ctgr++;
			}
	
			// Is the type number same ?
			if	( itsFile.file_type == data.type_idnt ) {
				itsCategory = ctgr;
				break;
			}
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewFile::SetCategory", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewFile::SetCategory", "unknown" );
	}
}

// --------------------------------------------------------------------
// EOF:	CPreviewFile.cxx
// --------------------------------------------------------------------
