// --------------------------------------------------------------------
// CPreviewShots.cxx
// Whatis:	Screenshot preview system
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CPreviewShots.hxx"
#include	"CError.hxx"
#include	"CCache.hxx"
#include	"CUnLevelInfo.hxx"
#include	"CPicture.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CFurpileLogo.hxx"

// --------------------------------------------------------------------
// public:		Constructor
// --------------------------------------------------------------------
CPreviewShots::CPreviewShots ( void ) {
	CPreviewShots::Cleanup();
}

// --------------------------------------------------------------------
// public:		Destructor
// --------------------------------------------------------------------
CPreviewShots::~CPreviewShots ( void ) {
	CPreviewShots::Free();
}

// --------------------------------------------------------------------
// public:		Load the information
// --------------------------------------------------------------------
void	CPreviewShots::Load	(	const char * 	aUnrFile,
								dword_t			aFileIdnt,
								dword_t			aDetailShot ) {
	try	{
		CPreviewShots::Free();

		CUnFile			f( aUnrFile );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
		CUnLevelInfo	l( f, n, e, i );
		CCache			mycache( "preview" );

		// Set up the default URL and path
		::strcpy( itsBaseUrl, mycache.UrlBase() );
		::strcpy( itsBasePath, mycache.DirBase() );

		for	( itsShotCount = 0; itsShotCount < l.ShotCount(); itsShotCount++ ) {

			// Don't exceed out limits
			if	( itsShotCount == MAX_SCREENSHOT )	break;

			// Set up the thumbnail file name
			::sprintf( itsThumbnail[itsShotCount], "%d-shottn-%d.jpg", aFileIdnt, itsShotCount );

			// If this is the default one, set default shot name as well
			if	( aDetailShot == itsShotCount ) {
				::sprintf( itsDetailShot, "%d-shot-%d.jpg", aFileIdnt, itsShotCount );
			}


			// Set up path names
			char	thmbpath[1024];
			char	detapath[1024];

			mycache.MakeDirname( thmbpath, itsThumbnail[itsShotCount] );
			mycache.MakeDirname( detapath, itsDetailShot );

			// Should we process the image ?
			if		( ( ! mycache.Exist( thmbpath ) ) ||
					  ( ( aDetailShot == itsShotCount ) && ( ! mycache.Exist( detapath ) ) ) ) {

				CPicture					mypicture;
				CPictureSourceUTX			myutx( l.Screenshot( itsShotCount ) );

				// Load the picture and take care of the alpha
				mypicture.Load( myutx );

				// Create full size shot if this is the detail shot
				if	( aDetailShot == itsShotCount ) {
					CFurpileLogo		logo( "Furpile.utx" );
					CPictureSourceJPG	myjpg( detapath, 70 );

					logo.Plant( mypicture.PixmapRef() );
					mypicture.Save( myjpg );
					mycache.Cache( detapath );
				}

				if	( ! mycache.Exist( thmbpath ) ) {
					CPictureFilterScale	thumbnail( 64, 64 );
					CPictureSourceJPG	myjpg( thmbpath, 70 );

					mypicture.Filter( thumbnail );
					mypicture.Save	( myjpg );
					mycache.Cache	( thmbpath );
				}
			}
		}
	}

	catch	( CError e ) {
		throw CError( "CPreviewShots::Load", e.Error() );
	}

	catch	( ... ) {
		throw CError( "CPreviewShots::Load", "unknown" );
	}

}

// --------------------------------------------------------------------
// public:		Try answering a question
// --------------------------------------------------------------------
bool	CPreviewShots::Answer	( const char * aQ ) const {
	if		( ! ::strcmp( aQ, "scrnshottn" ) )	{ ::printf( "%s", itsThumbnail[itsShotIdx] ); return true; }
	else if	( ! ::strcmp( aQ, "scrnshotix" ) )	{ ::printf( "%d", itsShotIdx ); return true; }
	else if	( ! ::strcmp( aQ, "scrnshot" ) )	{ ::printf( "%s", itsDetailShot ); return true; }
	else if	( ! ::strcmp( aQ, "imageurl" ) )	{ ::printf( "%s", itsBaseUrl ); return true; }

	return	false;
}

// --------------------------------------------------------------------
// private		Free data
// --------------------------------------------------------------------
void	CPreviewShots::Free	( void ) {
	CPreviewShots::Cleanup();
}

// --------------------------------------------------------------------
// private		Clean up the mess
// --------------------------------------------------------------------
void	CPreviewShots::Cleanup	( void ) {
	::memset( itsThumbnail,		0, sizeof( itsThumbnail ) );
	::memset( itsDetailShot,	0, sizeof( itsDetailShot ) );
	::memset( itsBaseUrl,		0, sizeof( itsBaseUrl ) );
	::memset( itsBasePath,		0, sizeof( itsBasePath ) );
	itsShotIdx		= 0;
	itsShotCount	= 0;
}

// --------------------------------------------------------------------
// EOF:	CPreviewShots.cxx
// --------------------------------------------------------------------
