// --------------------------------------------------------------------
// CScore.cxx
// Whatis:	Class for detecting spam
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-APR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CScore.hxx"

// --------------------------------------------------------------------
// public:	Constructors
// --------------------------------------------------------------------
CScore::CScore ( const data_file_t & aFd ) {
	CScore::Calculate( aFd.file_rat0, aFd.file_rat1, aFd.file_rat2 );
}

// --------------------------------------------------------------------
CScore::CScore ( const data_auth_t & aAd ) {
	CScore::Calculate( aAd.auth_rat0, aAd.auth_rat1, aAd.auth_rat2 );
}

// --------------------------------------------------------------------
CScore::~CScore ( ) {
}

// --------------------------------------------------------------------
void	CScore::Calculate ( dword_t aB, dword_t aA, dword_t aG ) {
	itsSumScore = aB + aA + aG;

	if		( itsSumScore == 0 ) {
		itsBadScore = 0;
		itsAvgScore = 0;
		itsGodScore = 0;
	}
	else {
		if	( aB == 0 )	itsBadScore	= 0;
		else			itsBadScore = (aB * 100) / itsSumScore;

		if	( aA == 0 )	itsAvgScore	= 0;
		else			itsAvgScore = (aA * 100) / itsSumScore;

		if	( aG == 0 )	itsGodScore	= 0;
		else			itsGodScore = (aG * 100) / itsSumScore;
	}
}

// --------------------------------------------------------------------
// EOF:	CScore.cxx
// --------------------------------------------------------------------
