// --------------------------------------------------------------------
// CSession.cxx
// Whatis:	Session manipulation
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-JUL-2002		Created	this source
// --------------------------------------------------------------------
#include	"CError.hxx"
#include	"CSession.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CTablePref.hxx"
#include	"CTableSess.hxx"
#include	"CMySqlWhere.hxx"

static	CTableUser	user;
static	CTableSess	sess;
static	CTablePref	pref;

static	dword_t		__saveid	= 0;
static	CCgiArgs *	__cgi		= NULL;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {
	if		( ::cgi_parser( *__cgi, aQ ) )	;
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// public:		Constructors
// --------------------------------------------------------------------
CSession::CSession ( const CCgiArgs & aCgi ) {

	CSession::Cleanup();

	// ----------------------------------------------------------------
	// Check if this user uses cookie, logged in or is using session
	// ----------------------------------------------------------------
	CMySqlConnect	db( "quest", "", "UTCMS" );
	if		(	CSession::CheckCookie( aCgi, db ) )	;
	else if	(   CSession::CheckLogIn( aCgi, db ) )	;
	else		CSession::CheckSess( aCgi, db );
}

// --------------------------------------------------------------------
CSession::CSession (	CCgiArgs & 			aCgi,
						const char *		aLoginTemplate,
						const char *		aForwardAddress,
						const char *		aSaveDir,
						const char **		aArgNames ) {

	CSession::Cleanup();

	// ----------------------------------------------------------------
	// Check if this user uses cookie, logged in or is using session
	// ----------------------------------------------------------------
	CMySqlConnect	db( "quest", "", "UTCMS" );
	if		(	CSession::CheckCookie( aCgi, db ) )	;
	else if	(   CSession::CheckLogIn( aCgi, db ) )	;
	else		CSession::CheckSess( aCgi, db );

	// ----------------------------------------------------------------
	// In POST mode - we must do forwarding
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aCgi.Arg( CGI_REQUEST_METHOD ), "POST" ) ) {
		if	( ( aSaveDir ) && ( aArgNames ) )	__saveid = aCgi.Save( aSaveDir, aArgNames );
		::HTTP_html( "en" );
		::printf( "<html>\n" );
		::printf( "\t<head>\n" );
		::printf( "\t\t<title>Redirecting</title>\n" );
		::printf( "\t</head>\n" );
		::printf( 	"\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s?user=%d&sess=%d&save=%d');\">\n",
					aForwardAddress, itsUser.user_idnt, itsSessId, __saveid );
		::printf( "\t\t<center><b><font color=\"Yellow\">Processing</font></b></center>\n" );
		::printf( "\t</body>\n" );
		::printf( "</html>\n" );
		itsChecked = false;	// Will skip processing
	}

	// ----------------------------------------------------------------
	// Was not able to log in ....
	// ----------------------------------------------------------------
	else if	( ! itsChecked ) {
		if	( aLoginTemplate ) {
			CPreviewTemplate	previewtemplate;
			::HTTP_text( "en" );
			__cgi =& aCgi;
			previewtemplate.Execute( __answer, aLoginTemplate );
		}
		else if	( ( aCgi.Exist( "save" ) ) && ( aSaveDir ) && ( aArgNames ) ) {
			aCgi.Load( aSaveDir, aArgNames, ::atol( aCgi.Arg( "save" ) ) );
		}
	}

	// ----------------------------------------------------------------
	// Will continue processing ... logged in and not in POST mode
	// ----------------------------------------------------------------
	else {
		if	( ( aCgi.Exist( "save" ) ) && ( aSaveDir ) && ( aArgNames ) ) {
			aCgi.Load( aSaveDir, aArgNames, ::atol( aCgi.Arg( "save" ) ) );
		}
	}
}


// --------------------------------------------------------------------
// public:		Log me out
// --------------------------------------------------------------------
void	CSession::Logout ( const CCgiArgs & aCgi ) {
	if	( itsChecked ) {
		::HTTP_kill_cookie(	itsCookieName,
							aCgi.Arg( itsCookieName ),
							itsCookiePath );
		CMySqlConnect	db( "quest", "", "UTCMS" );
		::memset( itsUser.user_cook, 0, sizeof( itsUser.user_cook ) );
		user.Update( db, &itsUser );
		itsChecked	= false;
		itsSessId	= 0;
	}
}

// --------------------------------------------------------------------
// public:		Do I have a cookie ?
// --------------------------------------------------------------------
bool	CSession::HasCookie		( const CCgiArgs & aCgi ) {
	CMySqlConnect	db( "quest", "", "UTCMS" );
	data_pref_tl	plist;
	plist = pref.Select( db, " where pref_name='cookie-name'" );
	if	( plist.size() < 1 )	return false;	
	::strcpy( itsCookieName, (*(plist.begin())).pref_valu );

	// Is the cookie there ?
	if	( ! aCgi.Exist( itsCookieName ) )	return false;

	// Do we have a user table entry with it ?
	data_user_tl	ulist;
	CMySqlWhere		w;
	CMySqlQuote		q;

	w << "user_cook='" << q.Quote( aCgi.Arg( itsCookieName ) ) << "'";
	ulist = user.Select( db, w );
	if	( ulist.size() < 1 )	return false;

	itsUser = *(ulist.begin());

	// ----------------------------------------------------------------
	// Banned ?
	// ----------------------------------------------------------------
	if	( CSession::IsBanned() )	return false;

	return	true;
}

// --------------------------------------------------------------------
// private:		Check if this user has the cookie
// --------------------------------------------------------------------
bool	CSession::CheckCookie	( const CCgiArgs & aCgi, CMySqlConnect & aDb ) {
	// Get the cookie name from preferences
	data_pref_tl	plist;

	plist = pref.Select( aDb, " where pref_name='cookie-name'" );
	if	( plist.size() < 1 )	return false;	
	::strcpy( itsCookieName, (*(plist.begin())).pref_valu );

	plist = pref.Select( aDb, " where pref_name='cookie-info'" );
	if	( plist.size() < 1 )	return false;	
	::strcpy( itsCookieInfo, (*(plist.begin())).pref_valu );

	plist = pref.Select( aDb, " where pref_name='cookie-path'" );
	if	( plist.size() < 1 )	return false;	
	::strcpy( itsCookiePath, (*(plist.begin())).pref_valu );

	// Is the cookie there ?
	if	( ! aCgi.Exist( itsCookieName ) )	return false;


	// Do we have a user table entry with it ?
	data_user_tl	ulist;
	CMySqlWhere		w;
	CMySqlQuote		q;

	w << "user_cook='" << q.Quote( aCgi.Arg( itsCookieName ) ) << "'";
	ulist = user.Select( aDb, w );
	if	( ulist.size() < 1 )	return false;

	itsUser = *(ulist.begin());

	// ----------------------------------------------------------------
	// Banned ?
	// ----------------------------------------------------------------
	if	( CSession::IsBanned() ) {
		::HTTP_kill_cookie(	itsCookieName,
							aCgi.Arg( itsCookieName ),
							itsCookiePath );
		return false;
	}

	// ----------------------------------------------------------------
	// Update user access time
	// ----------------------------------------------------------------
	itsUser.user_ltim = ::time( NULL );
	user.Update( aDb, &itsUser );

	// Accepted this user
	itsSessId	= 1;
	itsLogged = itsChecked	= true;
	return	true;
}

// --------------------------------------------------------------------
// private:		Check if this user just logged in
// --------------------------------------------------------------------
bool	CSession::CheckLogIn	( const CCgiArgs & aCgi, CMySqlConnect & aDb ) {

	// ----------------------------------------------------------------
	// There must exist login and password
	// ----------------------------------------------------------------
	if	( ! aCgi.Exist( "pass" ) )		return false;
	if	( ! aCgi.Exist( "user_logn" ) )	return false;

	// ----------------------------------------------------------------
	// Try to locate the user from database - if not found -> login fail
	// ----------------------------------------------------------------
	data_user_tl	list;
	CMySqlWhere		w;
	CMySqlQuote		q;

	w << "user_logn='" << q.Quote( aCgi.Arg( "user_logn" ) ) << "'";
	list = user.Select( aDb, w );
	
	if	( list.size() < 1 )													return false;
	if	( ::strcmp( (*(list.begin())).user_pass, aCgi.Arg( "pass" )  ) )	return false;

	itsUser = *(list.begin());

	if	( CSession::IsBanned() )	return false;

	// ----------------------------------------------------------------
	// Update user access time
	// ----------------------------------------------------------------
	itsUser.user_ltim = ::time( NULL );
	::memset( itsUser.user_cook, 0, sizeof( itsUser.user_cook ) );
	user.Update( aDb, &itsUser );

	// ----------------------------------------------------------------
	// Create a new session/cookie for this user and let go
	// ----------------------------------------------------------------
	if	( CSession::CreateCookie( aDb, aCgi ) ) {
		itsSessId = 1;
	}
	else {
		CSession::CreateSession( aDb, aCgi );
		if	( aCgi.Exist( itsCookieName ) ) {
			::HTTP_kill_cookie(	itsCookieName,
								aCgi.Arg( itsCookieName ),
								itsCookiePath );
		}
	}

	itsLogged = itsChecked = true;
	return	true;
}

// --------------------------------------------------------------------
// private:		Check if this user uses session
// --------------------------------------------------------------------
void	CSession::CheckSess	( const CCgiArgs & aCgi, CMySqlConnect & aDb ) {

	// ----------------------------------------------------------------
	// There must exist session and user ID
	// ----------------------------------------------------------------
	if	( ! aCgi.Exist( "sess" ) )	return;
	if	( ! aCgi.Exist( "user" ) )	return;

	// ----------------------------------------------------------------
	// Try to locate the session
	// ----------------------------------------------------------------
	CMySqlWhere		w;
	data_sess_tl	slist;
	data_sess_t		sdata;
	data_user_tl	ulist;

	// ----------------------------------------------------------------
	// Remove any sessions that are too old
	// ----------------------------------------------------------------
	w << "sess_time < " << (dword_t)::time( NULL );
	sess.Delete( aDb, w );

	// ----------------------------------------------------------------
	// Now, try to get the session
	// ----------------------------------------------------------------
	w = "";
	w << "sess_idnt=" << (dword_t)::atol( aCgi.Arg( "sess" ) ) << " and ";
	w << "sess_user=" << (dword_t)::atol( aCgi.Arg( "user" ) );

	slist = sess.Select( aDb, w );
	if	( slist.size() < 1 )	return;

	sdata = *(slist.begin());

	// ----------------------------------------------------------------
	// As we have got it, we will delete it as well
	// ----------------------------------------------------------------
	sess.Delete( aDb, w );

	// ----------------------------------------------------------------
	// The IP address must match
	// ----------------------------------------------------------------
	if	( ::strcmp( aCgi.Arg( CGI_REMOTE_ADDR ), sdata.sess_addr ) )	return;

	// ----------------------------------------------------------------
	// Now, locate the guy from database
	// ----------------------------------------------------------------
	w = "";
	w << "user_idnt=" << (dword_t)::atol( aCgi.Arg( "user" ) );

	ulist = user.Select( aDb, w );
	if	( ulist.size() < 1 )	return;
	itsUser = *(ulist.begin());

	if	( CSession::IsBanned() )	return;

	// ----------------------------------------------------------------
	// Update user access time
	// ----------------------------------------------------------------
	itsUser.user_ltim = ::time( NULL );
	::memset( itsUser.user_cook, 0, sizeof( itsUser.user_cook ) );
	user.Update( aDb, &itsUser );

	// ----------------------------------------------------------------
	// Create a new session/cookie for this user and let go
	// ----------------------------------------------------------------
	if	( CSession::CreateCookie( aDb, aCgi ) ) {
		itsSessId = 1;
	}
	else {
		CSession::CreateSession( aDb, aCgi );
		if	( aCgi.Exist( itsCookieName ) ) {
			::HTTP_kill_cookie(	itsCookieName,
								aCgi.Arg( itsCookieName ),
								itsCookiePath );
		}
	}

	itsLogged = itsChecked = true;
}

// --------------------------------------------------------------------
// private:		Create a new session for this user
// --------------------------------------------------------------------
void	CSession::CreateSession	( CMySqlConnect & aDb, const CCgiArgs & aCgi ) {
	CMySqlWhere		w;
	data_sess_t		sdata;

	// ----------------------------------------------------------------
	// Remove any sessions that are too old
	// ----------------------------------------------------------------
	w << "sess_time < " << (dword_t)::time( NULL );
	sess.Delete( aDb, w );

	// ----------------------------------------------------------------
	// Fill in the session and put it into database
	// ----------------------------------------------------------------
	::memset( &sdata, 0, sizeof( sdata ) );

	sdata.sess_user = itsUser.user_idnt;
	sdata.sess_time = (dword_t)( ::time( NULL ) + 3600 );	// Valid for an hour
	::strcpy( sdata.sess_pass, itsUser.user_pass );
	::strcpy( sdata.sess_addr, aCgi.Arg( CGI_REMOTE_ADDR ) );

	do	{
		sdata.sess_idnt = (dword_t)rand();
		w = "";
		w << "sess_idnt=" << sdata.sess_idnt;
	}	while ( sess.Count( aDb, w ) > 0 );

	sess.Insert( aDb, &sdata );

	itsSessId = sdata.sess_idnt;
}

// --------------------------------------------------------------------
// private:		Create cookie for this user
// --------------------------------------------------------------------
bool	CSession::CreateCookie	( CMySqlConnect & aDb, const CCgiArgs & aCgi ) {
	if	( (itsUser.user_flag & FLAG_USECOOKIES) == 0 )	return false;
	if	( itsCookieName[0] == 0 )						return false;

	// Set up the cookie value
	::memset( itsUser.user_cook, 0, sizeof( itsUser.user_cook ) );
	::sprintf(	itsUser.user_cook, "%s.%d",
				aCgi.Arg( CGI_REMOTE_ADDR ),
				itsUser.user_idnt );

	::my_encrypt( itsUser.user_cook );

	user.Update( aDb, &itsUser );

	::HTTP_cookie(	itsCookieName,
					itsUser.user_cook,
					itsCookiePath,
					itsCookieInfo );

	return	true;
}

// --------------------------------------------------------------------
// private:		Check if this guy is banned or something
// --------------------------------------------------------------------
bool	CSession::IsBanned	( void ) const {

	// ----------------------------------------------------------------
	// If this user has been banned, we don't allow him to check in
	// ----------------------------------------------------------------
	if	( (itsUser.user_flag & FLAG_BANNED) != 0 ) return true;

	// ----------------------------------------------------------------
	// Same applies if the user has not been accepted
	// ----------------------------------------------------------------
	if	( (itsUser.user_flag & FLAG_ACCEPTED) == 0 ) return true;

	// ----------------------------------------------------------------
	// Empty passwords will also cause login to fail
	// ----------------------------------------------------------------
	if	( itsUser.user_pass[0] == 0 )	return true;

	return	false;
}

// --------------------------------------------------------------------
// private:		Clean up
// --------------------------------------------------------------------
void	CSession::Cleanup ( void ) {
	::memset( &itsUser, 0, sizeof( itsUser ) );
	::memset( &itsCookieName, 0, sizeof( itsCookieName ) );
	::memset( &itsCookieInfo, 0, sizeof( itsCookieInfo ) );
	::memset( &itsCookiePath, 0, sizeof( itsCookiePath ) );
	itsChecked	= false;
	itsLogged	= false;
	itsSessId	= 0;
}

// --------------------------------------------------------------------
// EOF:	CSession.cxx
// --------------------------------------------------------------------
