// --------------------------------------------------------------------
// CWinIniFile.hxx
// Whatis:  Windows style INI file item
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CWinIniFile_hxx
#define CWinIniFile_hxx

#include	"CWinIniSection.hxx"

// --------------------------------------------------------------------
class CWinIniFile {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CWinIniFile		();
	~CWinIniFile	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CWinIniFile				( const CWinIniFile & );
	CWinIniFile operator =	( const CWinIniFile & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator ==		( const CWinIniFile & );
	bool operator !=		( const CWinIniFile & );

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Write	( FILE * ) const;
	void			Write	( const char * ) const;
	void			Read	( FILE * );
	void			Read	( const char * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *				Name		( void ) const;
	const CWinIniSection_l &	SectionList	( void ) const;
	CWinIniSection				Section		( const char * aName ) const;
	const CWinIniSection *		SectionPtr	( const char * aName ) const;
	void						SectionList	( const CWinIniSection_l & );
    CWinIniItem_l			  	ItemList	( const char * aSectName, const char * aItemName ) const;
	void						Name		( const char * aName );
	void						Insert		( const CWinIniSection & );
	void						Insert		( const CWinIniSection_l & );
    void						Insert		( const char * aSectName, const char * aName, const char * aValue );
	void						Delete		( const CWinIniSection & );
	void						Delete		( const CWinIniSection_l & );
    void						Delete		( const char * aSectName, const char * aName );
    void						Clear		( void );
    const char *				Value		( const char * aSectName, const char * aItemName ) const;
    dword_t						IntValue	( const char * aSectName, const char * aItemName ) const;
    bool						BoolValue	( const char * aSectName, const char * aItemName ) const;
    void						Value		( const char * aSectName, const char * aName, const char * aValue );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *				itsName;
	CWinIniSection_l	itsSectionList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CWinIniFile>		CWinIniFile_l;
typedef CWinIniFile_l::iterator       	CWinIniFile_li;
typedef CWinIniFile_l::const_iterator	CWinIniFile_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CWinIniFile.hxx
// --------------------------------------------------------------------
