// --------------------------------------------------------------------
// CWinIniSection.hxx
// Whatis:  Windows style INI file item
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 10-FEB-2003     Created this source
// --------------------------------------------------------------------
#ifndef CWinIniSection_hxx
#define CWinIniSection_hxx

#include	"CWinIniItem.hxx"

// --------------------------------------------------------------------
class CWinIniSection {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CWinIniSection	();
	~CWinIniSection	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CWinIniSection				( const CWinIniSection & );
	CWinIniSection operator =	( const CWinIniSection & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator ==		( const CWinIniSection & ) const;
	bool operator !=		( const CWinIniSection & ) const;
	bool operator ==		( const char * ) const;
	bool operator !=		( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Streaming
	// ----------------------------------------------------------------
	void			Write	( FILE * ) const;
	void			Read	( FILE * );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const char *			Name	( void ) const;
	const CWinIniItem_l &	ItemList( void ) const;
    CWinIniItem_l			ItemList( const char * aName ) const;
	void					ItemList( const CWinIniItem_l & );
	void					Name	( const char * aName );
	void					Insert	( const CWinIniItem & );
	void					Insert	( const CWinIniItem_l & );
	void					Delete	( const CWinIniItem & );
	void					Delete	( const CWinIniItem_l & );
    void					Clear	( void );
    const char *			Value	( const char * aName ) const;

	// ----------------------------------------------------------------
	public:		// Special inserts for easier manipulation
	// ----------------------------------------------------------------
	void					Insert	( const char * aName, const char * aV );
	void					Insert	( const char * aName, bool aV );
	void					Insert	( const char * aName, int aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
	void				Cleanup	( void );
	void				Free	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *			itsName;
	CWinIniItem_l	itsItemList;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef list <class CWinIniSection>			CWinIniSection_l;
typedef CWinIniSection_l::iterator       	CWinIniSection_li;
typedef CWinIniSection_l::const_iterator	CWinIniSection_lci;

#endif
// --------------------------------------------------------------------
// EOF:	CWinIniSection.hxx
// --------------------------------------------------------------------
