// --------------------------------------------------------------------
// CCrc32.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CCrc32_hxx
#define	CCrc32_hxx

#include	"IChecksum.hxx"

// --------------------------------------------------------------------
// Declaration of the CCrc32 class
// --------------------------------------------------------------------
class	CCrc32 : public IChecksum {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CCrc32	();
	CCrc32	( dword_t aV );
	~CCrc32	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CCrc32				( const CCrc32 & aC );
    CCrc32 & operator =	( const CCrc32 & aC );
    CCrc32 & operator =	( dword_t aV );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CCrc32 & aC ) const;
	bool operator != ( const CCrc32 & aC ) const;

	// ----------------------------------------------------------------
	public:		// Interface for calculator
	// ----------------------------------------------------------------
	void	Calculate	( const void * aData, dword_t aLen );
	void	Cleanup		( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    dword_t	Crc32	( void ) const;
    void	Crc32	( dword_t aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsCrc32;
};

#endif	// #ifdef  CCrc32_hxx
// --------------------------------------------------------------------
// EOF:	CCrc32.hxx
// --------------------------------------------------------------------
