// --------------------------------------------------------------------
// CGzCm.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzCm_hxx
#define	CGzCm_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzCm class
// --------------------------------------------------------------------
class	CGzCm {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzCm	();
	~CGzCm	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzCm				( const CGzCm & );
    CGzCm & operator =	( const CGzCm & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read	( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write	( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup	( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	byte_t		Cm		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free	( void );
	void		Clear	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsCm;
};

#endif	// #ifdef  CGzCm_hxx
// --------------------------------------------------------------------
// EOF:	CGzCm.hxx
// --------------------------------------------------------------------
