// --------------------------------------------------------------------
// CGzData.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzData_hxx
#define	CGzData_hxx

#include	"IZipStream.hxx"
#include	"CZipDword.hxx"
#include	"CZipCrc32.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzData class
// --------------------------------------------------------------------
class	CGzData {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzData	();
	~CGzData	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzData					( const CGzData & );
    CGzData & operator =	( const CGzData & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup		( void );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
    CZipCrc32		Crc32					( void ) const;
    CZipDword		Isize					( void ) const;
	const byte_t *	Data					( void ) const;
    const char *	CompressedFileName		( void ) const;
	dword_t			CompressedFileOffset	( void ) const;
	dword_t			CompressedDataSize		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    CZipCrc32	itsCrc32;
    CZipDword	itsIsize;
	byte_t *	itsData;
    char *		itsCompressedFileName;
	dword_t		itsCompressedFileOffset;
	dword_t		itsCompressedDataSize;
};

#endif	// #ifdef  CGzData_hxx
// --------------------------------------------------------------------
// EOF:	CGzData.hxx
// --------------------------------------------------------------------
