// --------------------------------------------------------------------
// CGzFhCrc.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzFhCrc_hxx
#define	CGzFhCrc_hxx

#include	"CZipWord.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzFhCrc class
// --------------------------------------------------------------------
class	CGzFhCrc {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzFhCrc	();
	~CGzFhCrc	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzFhCrc				( const CGzFhCrc & );
    CGzFhCrc & operator =	( const CGzFhCrc & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read	( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write	( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup	( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	CZipWord	Crc		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free	( void );
	void		Clear	( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipWord	itsCrc;
};

#endif	// #ifdef  CGzFhCrc_hxx
// --------------------------------------------------------------------
// EOF:	CGzFhCrc.hxx
// --------------------------------------------------------------------
