// --------------------------------------------------------------------
// CGzFname.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzFname_hxx
#define	CGzFname_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzFname class
// --------------------------------------------------------------------
class	CGzFname {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzFname	();
	~CGzFname	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzFname				( const CGzFname & );
    CGzFname & operator =	( const CGzFname & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup		( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	const char *	Fname	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free		( void );
	void		Clear		( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	char *		itsFname;
};

#endif	// #ifdef  CGzFname_hxx
// --------------------------------------------------------------------
// EOF:	CGzFname.hxx
// --------------------------------------------------------------------
