// --------------------------------------------------------------------
// CGzId.hxx
// Whatis:	gz id
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzId_hxx
#define	CGzId_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzId class
// --------------------------------------------------------------------
class	CGzId {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzId	();
	~CGzId	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzId				( const CGzId & );
    CGzId & operator =	( const CGzId & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );


	// ----------------------------------------------------------------
	void		Cleanup				( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	byte_t		Id1	( void ) const;
	byte_t		Id2	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsId1;
	byte_t		itsId2;
};

#endif	// #ifdef  CGzId_hxx
// --------------------------------------------------------------------
// EOF:	CGzId.hxx
// --------------------------------------------------------------------
