// --------------------------------------------------------------------
// CGzMtime.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzMtime_hxx
#define	CGzMtime_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzMtime class
// --------------------------------------------------------------------
class	CGzMtime {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzMtime	();
	~CGzMtime	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzMtime				( const CGzMtime & );
    CGzMtime & operator =	( const CGzMtime & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup				( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	time_t		Time	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	time_t		itsTime;
};

#endif	// #ifdef  CGzMtime_hxx
// --------------------------------------------------------------------
// EOF:	CGzMtime.hxx
// --------------------------------------------------------------------
